/*
 * calibration routines for computing mouse coordinates
 *
 * Copyright 1994, Bruno Olshausen and Bill Press
 * Washington University School of Medicine
 *
 */

#include <stdio.h>
#include <math.h>
#include "mk_areas.h"
#include "coords.h"

CalibrateType	slice;
ScaleType	scale;
int		validCoord=0;

validCoordP()
{
  return(validCoord);
}

StereotaxPoint win2coord(int x, int y, int reversed)
{
  PixPoint	 win_pos;
  StereotaxPoint st_pos;
  
  win_pos.x=x;
  win_pos.y=y;
  return(pixToSt(&win_pos,&slice,&scale, reversed));
}

StereotaxPoint pixToSt(PixPoint *original, CalibrateType *slice, ScaleType *scale, int reversed)
{
    StereotaxPoint converted;

    int		   newX;
    int		   newY;
    
    newY = (int) fabs ((double) original->y - image.height); /* temp fix ! */

    newX = (!reversed)? original->x : (int) fabs ((double) original->x - image.width); /* temp fix ! */
    
    converted.x = slice->coords[0].sX + scale->toSt.x*(newX - slice->coords[0].pX);
    converted.y = slice->coords[0].sY + scale->toSt.y*(newY - slice->coords[0].pY);
   
    return(converted);
}

PixPoint stToPix(StereotaxPoint *original, CalibrateType *slice, ScaleType *scale, int reversed)
{
    PixPoint converted;

    int	     oldX;
    int	     oldY;
    
    oldX	= rint(slice->coords[0].pX + scale->toPix.x*(original->x - slice->coords[0].sX));
    oldY        = rint(slice->coords[0].pY + scale->toPix.y*(original->y - slice->coords[0].sY));

    converted.x = (!reversed)? oldX : (int) fabs ((double) oldX - image.width); /* temp fix */
    converted.y = (int) fabs ((double) oldY - image.height); /* temp fix */
   
    return(converted);
}

void initConversion(char *filename)
{
    int j;
    FILE *fp;

    if ((fp = fopen(filename, "r"))!=NULL) {
	
	for ( j=0; j<2; j++ ) {
	    fscanf(fp, "%d %d", &(slice.coords[j].sX), &(slice.coords[j].sY));
	    fscanf(fp, "%d %d", &(slice.coords[j].pX), &(slice.coords[j].pY));
	}
	fclose(fp);

	scale.toSt.x = ((double)(slice.coords[1].sX-slice.coords[0].sX)/
			    (double)(slice.coords[1].pX-slice.coords[0].pX));
	scale.toSt.y = ((double)(slice.coords[1].sY-slice.coords[0].sY)/
			    (double)(slice.coords[1].pY-slice.coords[0].pY));
	scale.toPix.x = 1/scale.toSt.x;
	scale.toPix.y = 1/scale.toSt.y;
	
	validCoord = 1;
    }
}
