#include <stdio.h>
#include <fcntl.h>
#include <malloc.h>

#include "mk_areas.h"

typedef struct area_in {
  Object	*object;
  char		name[CHARS_PER_LABEL];
  struct area_in *next;
} AreaIn;

int flip_short (short *orig_short)
{
	char	*orig_char, *copy_char;
	short	copy_short = *orig_short;

	short i;

	orig_char = (char *) orig_short;
	copy_char = (char *) (&copy_short)+1;

	for (i=0; i<2; i++)
		*orig_char++ = *copy_char--;
}

int flip_int (int *orig_int)
{
	char	*orig_char, *copy_char;
	int		copy_int = *orig_int;

	int i;

	orig_char = (char *) orig_int;
	copy_char = (char *) (&copy_int)+3;

	for (i=0; i<4; i++)
		*orig_char++ = *copy_char--;
}

double flip_double (double *orig_double)
{
	char	*orig_char, *copy_char;
	double	copy_double = *orig_double;

	double i;

	orig_char = (char *) orig_double;
	copy_char = (char *) (&copy_double)+7;

	for (i=0; i<8; i++)
		*orig_char++ = *copy_char--;
}

flip_object_to_big (Object *obj)
{
	int i;

	flip_int(&(obj->header.shape));
	flip_int(&(obj->header.type));
	 
	flip_int(&(obj->polygon.num_points));
	for (i=0; i<obj->polygon.num_points; i++) {
		flip_short(&(obj->polygon.points[i].x));
		flip_short(&(obj->polygon.points[i].y));
	}
}

flip_object_to_little (Object *obj)
{
	int i;

	for (i=0; i<obj->polygon.num_points; i++) {
		flip_short(&(obj->polygon.points[i].x));
		flip_short(&(obj->polygon.points[i].y));
	}
	flip_int(&(obj->polygon.num_points));

	flip_int(&(obj->header.shape));
	flip_int(&(obj->header.type));
}
