/*
 * file i/o
 *
 * Copyright 1994, Bruno Olshausen
 * Washington University School of Medicine
 *
 */

#include <fcntl.h>
#include <stdio.h>
#include "mk_areas.h"

int write_area_list(char *name)
{
    int	    	fd;
    Area	*currentArea;
    char    	*ch,line[80];
    extern char	*query();
    
    if ((fd = open(name, O_EXCL|O_CREAT|O_WRONLY, 0644))==-1) {
		sprintf(line,"OK to overwrite file: %s ? ",name);
		ch=query(line);
		if (*ch=='y' || *ch=='Y') {
			if ((fd = open(name, O_WRONLY))==-1)
				return(-1);
		} else
			return(-1);
    }

    for (currentArea=area_list;
		 currentArea!=NULL;
		 currentArea = currentArea->next ) {
		write(fd, currentArea, sizeof(Area));
		if (bigEndian)
			flip_object_to_little (currentArea->object);
		write(fd, currentArea->object, sizeof(Object));
		if (bigEndian)
			flip_object_to_big (currentArea->object);
    }

    close(fd);
    return(1);
}

Area *readAreas(char *name)
{
	int	    	fd;
	Area		*currentArea,*lastArea,*head;
	int	    	i;
    
	if ((fd = open(name, O_RDONLY))==-1) {
		fprintf(stderr, "Could not open file.\n");
		return(NULL);
	}

	head=currentArea=(Area *) calloc(1, sizeof(Area));
  
	while (read(fd, currentArea, sizeof(Area))==sizeof(Area)) {
    
		currentArea->object=(Object *)calloc(1,sizeof(Object));
		read(fd, currentArea->object, sizeof(Object));
		if (bigEndian)
			flip_object_to_big (currentArea->object);
   
		currentArea->next=(Area *) calloc(1, sizeof(Area));
		lastArea=currentArea;
		currentArea=currentArea->next;
	}
	close(fd);

	if (head==currentArea)
		head=NULL;
	else
		lastArea->next=NULL;
	free(currentArea);
	   
	
	return(head);
}

