/*
 * mk_areas.c:	program for defining and labeling areal boundaries for use
 *		by the graphical anatomical database
 *
 * usage:	mk_areas image_name
 *
 *		image_name must be included in the image_list file with the
 *		number of cols and rows defined.
 *
 * Copyright 1994, Bruno Olshausen and Bill Press
 * Washington University School of Medicine
 *
 */

#include <stdio.h>
#include <fcntl.h>
#include <malloc.h>

#include "mk_areas.h"

Image  		image;

Area		*area_list=0;
Area		*selected_area=NULL;

int		image_mode=IMAGE;
int		bigEndian;


main(argc,argv)
int	argc;
char	**argv;
{
  if (argc<2)
    fatal_error("usage: mk_areas image_name");

  /* init program */
  init(argv[1]);

  /* init user interface */
  setup_display();
  init_ui();


  /* go */
  main_event_loop();

}

#define IMAGE_LIST "image_list"
#define IMAGE_PATH "images/"
#define CAL_PATH "cal/"

init(image_name)
char	*image_name;
{
  int		i,cols,rows,found_it;
  char 		line[80],filename[80],name[80];
  FILE		*fp;
  char		*toEndianTest;
  int		endianTest = 1;

  /* figure out what kind of machine is being used */

  toEndianTest = (char *) &endianTest;
  bigEndian = *toEndianTest;

  /* find image_name in image_list */

  if ((fp=fopen(IMAGE_LIST,"r"))==NULL)
    fatal_error("couldn't open image_list");

  found_it=0;
  while (fgets(line,80,fp)) {
    sscanf(line,"%s %d %d",name, &cols, &rows);
    if (strcmp(image_name,name)==0) {
      found_it=1;
      break;
    }
  }
  fclose(fp);
  if (!found_it)
    fatal_error("couldn't find image in image_list");

  strcpy(filename,IMAGE_PATH);
  strcat(filename,image_name);
  if (read_image(filename,&image,cols,rows)==0) {
    fprintf(stderr,"couldn't read image: %s\n",filename);
    exit(1);
  }
  
  strcpy(filename,CAL_PATH);
  strcat(filename,image_name);
  initConversion(filename);
}

read_image(filename,iptr,cols,rows)
char	*filename;
Image	*iptr;
int	cols,rows;
{
  int		fd;
  char		overlay_file[80];

  if ((fd=open(filename,O_RDONLY))==-1)
    return(0);
  iptr->width=cols;
  iptr->height=rows;
  iptr->nrc=cols*rows;
  iptr->data = (byte *)calloc(iptr->nrc,sizeof(byte));
  MCHECK(iptr->data);
  if (read(fd,iptr->data,iptr->nrc) != iptr->nrc)
    fatal_error("image didn't contain expected number of pixels");
  close(fd);

  sprintf(overlay_file,"%s.overlay",filename);
  if ((fd=open(overlay_file,O_RDONLY))!=-1) {
    iptr->overlay = (byte *)calloc(iptr->nrc,sizeof(byte));
    MCHECK(iptr->overlay);
    if (read(fd,iptr->overlay,iptr->nrc) != iptr->nrc)
      fatal_error("overlay didn't contain expected number of pixels");
    close(fd);
  }
  else {
    iptr->overlay=NULL;
  }
    
  return(1);
}


/*
 * loading and saving data files
 */
file_handling(load_save)
int	load_save;
{
  char			line[80],filename[80],*answer;
  extern char		*query();

  if (load_save==LOAD) {
    answer=query("Load file: ");
    strcpy(filename,answer);
    if (strlen(filename)==0) {
      perr("Filename must contain at least one character");
      return;
    }
    if ((area_list=readAreas(filename))==NULL) {
      sprintf(line,"Problem in reading file: %s",filename);
      perr(line);
      return;
    }
    refresh_data_displays();
  }
  else {
    answer=query("Save to file: ");
    strcpy(filename,answer);
    if (strlen(filename)==0) {
      perr("Filename must contain at least one character");
      return;
    }
    if (write_area_list(filename)!=-1) {
      sprintf(line,"Saved to file: %s",filename);
      pmes(line);
      return;
    }
    else {
      sprintf(line,"Problem in saving to file: %s",filename);
      perr(line);
      return;
    }
  }
}
    

/*
 * finish
 */
quit_p()
{
  char		*ch;
  extern char	*query();

  ch=query("Are you sure you want to quit now? ");
  if (*ch=='y' || *ch=='Y')
    return(1);
  else
    return(0);
}


/*
 * image mode
 */
set_image_mode(mode)
int	mode;
{
  image_mode=mode;
  refresh_data_displays();
}

byte *get_image(image)
Image	*image;
{
  if (image_mode==IMAGE)
    return(image->data);
  else if (image->overlay)
    return(image->overlay);
  else
    return(image->data);
}


/*
 * error utilities
 */

fatal_error(s)
char	*s;
{
  fprintf(stderr,"mk_areas: %s\n",s);
  exit(1);
}

perr(s)
char	*s;
{
  fprintf(stderr,"");
  pmes(s);
}


