#define MCHECK(m) 	if (!m) fatal_error("malloc failed");

/* image/icon scale factor */
#define ICON_SF 4

/* image modes */
#define IMAGE 0
#define OVERLAY 1

#define NUM_ENTRY_ITEMS 1

#define CHARS_PER_LABEL 20

#define MAX_NUM_POLYGON_VERTICES 50

/* file */
#define LOAD 0
#define SAVE 1

typedef struct {
    double  x;
    double  y;
} StereotaxPoint;

typedef struct {
    short   x;
    short   y;
} PixPoint;

typedef struct {
  int		shape;
  int          type;
  union obj     *next;
} Header;

typedef struct {
  Header        header;
  PixPoint      points[MAX_NUM_POLYGON_VERTICES];
  int           num_points;
} Polygon;

typedef union obj {
  Header	header;
  Polygon       polygon;
} Object;


typedef struct area {
  Object	*object;
  char		name[CHARS_PER_LABEL];
  struct area 	*next;
} Area;

typedef unsigned char	byte;

typedef struct {
  byte	*data;
  byte	*overlay;
  int	width;
  int	height;
  int	nrc;
} Image;

extern Image		image;

extern Area		*area_list;
extern Area		*selected_area;

extern int 		image_mode;
extern int		bigEndian;

extern byte		*get_image();
extern Area	 	*readAreas();
