#include <X11/Xlib.h>

#define NUM_GREY_LEVELS 64
#define NUM_COLORS 8
#define NUM_GREY_LEVELS_PER_COLOR 16
#define COLOR_OFFSET 128

#define BLACK 0
#define WHITE (NUM_GREY_LEVELS-1)
#define DARK_BLUE (COLOR_OFFSET+NUM_GREY_LEVELS_PER_COLOR/2)
#define BLUE  (COLOR_OFFSET+NUM_GREY_LEVELS_PER_COLOR-1)
#define LIGHT_BLUE (COLOR_OFFSET+2*NUM_GREY_LEVELS_PER_COLOR-1)
#define GREEN (COLOR_OFFSET+(NUM_COLORS/2)*NUM_GREY_LEVELS_PER_COLOR-1)
#define RED   (COLOR_OFFSET+NUM_COLORS*NUM_GREY_LEVELS_PER_COLOR-1)


#define ERASE 0
#define DRAW NUM_GREY_LEVELS

#define ICON_BUFF 2

#define FLOAT_TO_INT(x) (int)(100*x)
#define INT_TO_FLOAT(x) ((double)x/100.0)

#define QUIT_ID 0
#define DRAW_MODE_ID 1
#define FILE_ID 2
#define IMAGE_MODE_ID 3
#define NUM_CONTROLS 4

typedef struct {
  Window	window;
  GC		gc;
  int		width;
  int		height;
} win_obj;

typedef struct {
  int		height;
  int		width;
  XFontStruct 	*info;
} font_obj;

typedef struct {
  char  	*label;
  int   	id;
  int		num_sub_choices;
  char		*sub_label[5];
} control_struct;

typedef struct {
  int	x,y;
} Coord;

extern Display 		*display;
extern int     		screen;
extern XImage		*ximage;
extern XGCValues	gc_values;
extern XEvent		event;
extern Cursor		cross_cursor,arrow_cursor;

extern font_obj		small_font,medium_font,large_font;

extern win_obj		control_win,image_win,entry_win,message_win,coord_win;
extern GC		image_xor_gc, image_handle_gc;

extern control_struct   control_list[NUM_CONTROLS];
 
extern int		div;

extern int		num_control_rows,num_controls_per_row;
extern Coord		control_spacing;

extern int		reverse_p;
