/*
 * drawing routines 
 *
 * Copyright 1994, Bruno Olshausen
 * Washington University School of Medicine
 *
 */
 

#include <stdio.h>
#include "mk_areas.h"
#include "ui.h"
#include "ui_text.h"


refresh_data_displays()
{
  redraw_image_win();
  redraw_entry_win();
}


redraw_image_win()
{
  Area	*area;

  deselect_area();
  XClearWindow(display,image_win.window);

  ximage->data= (char *)get_image(&image);
  XPutImage(display,image_win.window,image_win.gc,ximage,0,0,0,0,
	    ximage->width,ximage->height);
  area=area_list;
  while(area) {
    draw_object(area->object);
    area=area->next;
  }
}


str_pix_len(string,font)
char	*string;
font_obj *font;
{
  return(XTextWidth(font->info,string,strlen(string)));
}

redraw_control_win()
{
  int	i,j,index,x,y;

  index=0;
  for (j=0; j<num_control_rows; j++) {
    for (i=0; i<num_controls_per_row && index<NUM_CONTROLS; i++) {
      x= control_spacing.x*i;
      y= control_spacing.y*j;
      XSetForeground(display,control_win.gc,0);
      XDrawLine(display,control_win.window,control_win.gc,
		x+control_spacing.x,y,
		x+control_spacing.x,y+control_spacing.y);
      if (control_list[index].num_sub_choices)
	draw_submenu(&control_list[index],x,y);
      XSetForeground(display,control_win.gc,RED);
      XDrawImageString(display,control_win.window,control_win.gc,
                     x+(control_spacing.x-
			str_pix_len(control_list[index].label,&medium_font))/2,
		       y+control_spacing.y/2,
		       control_list[index].label,
		       strlen(control_list[index].label));
      index++;
    }
    if (j>0) {
      XSetLineAttributes(display,control_win.gc,2,LineSolid,CapButt,JoinMiter);
      XSetForeground(display,control_win.gc,0);
      XDrawLine(display,control_win.window,control_win.gc,
		0,y,control_win.width,y);
      XSetLineAttributes(display,control_win.gc,1,LineSolid,CapButt,JoinMiter);
    }
  }
}

draw_submenu(cptr,x,y)
control_struct	*cptr;
int		x,y;
{
  int	i,sub_hspace;

  sub_hspace=control_spacing.x/cptr->num_sub_choices;
  XSetFont(display,control_win.gc,small_font.info->fid);
  for (i=0; i<cptr->num_sub_choices; i++) {
    if (i!=0) {
      XSetForeground(display,control_win.gc,2*NUM_GREY_LEVELS/3);
      XDrawLine(display,control_win.window,control_win.gc,
		x+i*sub_hspace, y, x+i*sub_hspace, y+control_spacing.y);
    }
    XSetForeground(display,control_win.gc,BLUE);
    XDrawString(display,control_win.window,control_win.gc,
		x+(int)((sub_hspace)*(0.5+i))-
		str_pix_len(cptr->sub_label[i],&small_font)/2,
		y+control_spacing.y-3,
		cptr->sub_label[i],strlen(cptr->sub_label[i]));
  }
  XSetFont(display,control_win.gc,medium_font.info->fid);
}


/* text windows */


static char	*entry_label[NUM_ENTRY_ITEMS]= {"Area name:"};


redraw_entry_win()
{
  int	i,x,y;

  XClearWindow(display,entry_win.window);
  XSetFont(display,entry_win.gc,large_font.info->fid);
  XDrawString(display,entry_win.window,entry_win.gc,
	      (entry_win.width-str_pix_len("DATA",&large_font))/2,
	      large_font.height+4,
	      "DATA",strlen("DATA"));
  XSetFont(display,entry_win.gc,medium_font.info->fid);

  if (selected_area) {
    i=0;
    x=FIELD_BEGIN_X;
    y=FIELD_BEGIN_Y+i*FIELD_STEP;
    draw_label(&entry_win,entry_label[i],x,y);
    area2str(selected_area,string);
    draw_field(&entry_win,string,x,y);
  }
}

draw_label(obj,label,x,y)
win_obj	*obj;
char	*label;
int	x,y;
{
  XDrawString(display,obj->window,obj->gc,x,y,label,strlen(label));
  XDrawLine(display,obj->window,obj->gc,
	    x,y+2,x+str_pix_len(label,&medium_font),y+2);
}

draw_field(obj,string,x,y)
win_obj	*obj;
char	*string;
int	x,y;
{
  char	*str;
  int	i,chars_per_line,indent;

  str=string;
  i=0;
  indent=str_pix_len(INDENT,&medium_font);
  chars_per_line=(obj->width-(x+indent))/medium_font.width;
  while (strlen(str)>chars_per_line) {
    XDrawString(display,obj->window,obj->gc,
		x+indent, y+medium_font.height+BUFF + i*medium_font.height,
		str,chars_per_line);
    str+=chars_per_line;
    i++;
  }
  XDrawString(display,obj->window,obj->gc,
	      x+indent, y+medium_font.height+BUFF + i*medium_font.height,
	      str,strlen(str));
}


redraw_message_win()
{
  XClearWindow(display,message_win.window);

  XSetFont(display,message_win.gc,large_font.info->fid);
  XDrawString(display,message_win.window,message_win.gc,
	      (message_win.width-str_pix_len("MESSAGES",&large_font))/2,
	      large_font.height+4,
	      "MESSAGES",strlen("MESSAGES"));
  XSetFont(display,message_win.gc,medium_font.info->fid);
}


/* stereotaxic coordinate display */

redraw_coord_win()
{
  XClearWindow(display,coord_win.window);

  XSetFont(display,coord_win.gc,large_font.info->fid);
  XDrawString(display,coord_win.window,coord_win.gc,
	      (coord_win.width-str_pix_len("COORDINATES",&large_font))/2,
	      large_font.height+4,
	      "COORDINATES",strlen("COORDINATES"));
  XSetFont(display,coord_win.gc,medium_font.info->fid);
}

update_coord(x,y)
int	x,y;
{
  StereotaxPoint	st_coord;
  char			coord_string[20];
  extern StereotaxPoint	win2coord();

  clear_coord();
  
  st_coord=win2coord(x,y,reverse_p);
  sprintf(coord_string,"(%5.2lf, %5.2lf)",st_coord.x,st_coord.y);
  XDrawString(display,coord_win.window,coord_win.gc,
	      (coord_win.width-str_pix_len(coord_string,&medium_font))/2,
	      coord_win.height-5,
	      coord_string,strlen(coord_string));
}

clear_coord()
{
  XClearArea(display,coord_win.window,
	     0, coord_win.height-(medium_font.height+5),
	     coord_win.width, medium_font.height+5, False);
}

