/* 
 * event processing
 *
 * Copyright 1994, Bruno Olshausen and Bill Press
 * Washington University School of Medicine
 *
 */ 

#include <stdio.h>

#include "mk_areas.h"
#include "ui.h"
#include "ui_text.h"
#include <X11/keysym.h>

static int	done_p;

/*
 * main event loop
 */
main_event_loop()
{
  done_p=0;
  while (!done_p) {
    XNextEvent(display, &event);
    process_event(&event);
  }
}

process_event(event)
XEvent	*event;
{
  switch ((int) event->type) {
  case ButtonPress:
    process_button_press(event);
    break;
  case ButtonRelease:
    process_button_release(event);
    break;
  case MotionNotify:
    process_button_motion(event);
    break;
  case LeaveNotify:
    process_leaving(event);
    break;
  case KeyPress:
    process_key_press(event);
    break;
  case Expose:
    process_expose(event);
    break;
  }
}


/*
 * button events
 */

process_button_press(button_event)
XButtonEvent	*button_event;
{
  int		x,y,b;
  Window	win;

  win=button_event->window;
  b=button_event->button;
  x=button_event->x;
  y=button_event->y;

  if (win==control_win.window)
    process_control_win_button(x,y);
  else if (win==image_win.window)
    process_image_win_button(x,y,b);
  else if (win==entry_win.window)
    process_entry_win_button(x,y);
}

process_control_win_button(x,y)
int	x,y;
{
  int		index,x_index,y_index,sub_index;

  x_index=x/control_spacing.x;
  y_index=y/control_spacing.y;
  index=y_index*num_controls_per_row + x_index;
  if (index<NUM_CONTROLS) {
    if (control_list[index].num_sub_choices)
      sub_index=submenu_index(x,x_index,index);
    switch(control_list[index].id) {
    case QUIT_ID:
      done_p=quit_p();
      break;
    case DRAW_MODE_ID:
      set_draw_mode(sub_index);
      break;
    case FILE_ID:
      file_handling(sub_index);
      break;
    case IMAGE_MODE_ID:
      set_image_mode(sub_index);
    }
  }
}

submenu_index(x,i,index)
int	x,i,index;
{
  return((x-i*control_spacing.x)/
	 (control_spacing.x/control_list[index].num_sub_choices));
}

process_image_win_button(x,y,b)
int	x,y,b;
{
  drawing_press_action(x,y,b);
}

process_entry_win_button(x,y)
int	x,y;
{
  if (selected_area)
    new_field(&entry_win,x,y);
}


/* button release */

process_button_release(release_event)
XButtonReleasedEvent	*release_event;
{
  Window	win;

  win=release_event->window;

  if (win==image_win.window)
    process_image_win_release();
}

process_image_win_release()
{
  drawing_release_action();
}



/*
 * motion
 */

process_button_motion(motion_event)
XPointerMovedEvent	*motion_event;
{
  Window	win;
  int		x,y;

  win=motion_event->window;
  x=motion_event->x;
  y=motion_event->y;

  if (win==image_win.window)
    process_image_win_motion(x,y);
}

process_image_win_motion(x,y)
int	x,y;
{
  drawing_move_action(x,y);

  if (validCoordP())
    update_coord(x,y);
}


/*
 * leaving
 */

process_leaving(leave_event)
XLeaveWindowEvent	*leave_event;
{
  Window	win;

  win=leave_event->window;

  if (win==image_win.window)
    clear_coord();
}


/*
 * key events
 */
static char	kbuf[10];


process_key_press(key_event)
XKeyEvent	*key_event;
{
  KeySym keysym;

  XLookupString(key_event, kbuf, sizeof(kbuf), &keysym, NULL);

  if (key_event->window==entry_win.window && field_selected_p)
    process_text(&entry_win,keysym,kbuf);
  else if (key_event->window==image_win.window)
    process_graphics_keypress(kbuf);
}

process_text(obj,keysym,ch)
win_obj	*obj;
KeySym	keysym;
char	*ch;
{
 if (keysym==XK_Return)
   text_return(obj);
 else if ((keysym==XK_Delete) || (keysym==XK_BackSpace))
   backspace(obj);
 else if ((keysym>=XK_space) && (keysym<=XK_asciitilde))
   process_character(obj,ch);
}

process_graphics_keypress(ch)
char	*ch;
{
  if (*ch=='x' || *ch=='X')
    delete_area();
  if (*ch=='h' || *ch=='H')
    draw_all_handle_bars();
}



/*
 * Expose
 */
process_expose(expose_event)
XExposeEvent	*expose_event;
{
  if (expose_event->window==control_win.window)
    redraw_control_win();
  else if (expose_event->window==image_win.window)
    redraw_image_win(0);
  else if (expose_event->window==entry_win.window)
    redraw_entry_win();
  else if (expose_event->window==message_win.window)
    redraw_message_win();
  else if (expose_event->window==coord_win.window)
    redraw_coord_win();
}
