/*
 * user interface initialization
 *
 * Copyright 1994, Bruno Olshausen and Bill Press
 * Washington University School of Medicine
 *
 */

#include <stdio.h>

#include "mk_areas.h"
#include "ui.h"
#include <X11/Xutil.h>
#include <X11/cursorfont.h>

Display 	*display;
int     	screen;
XImage  	*ximage;
XGCValues	gc_values;
XEvent		event;
Cursor		cross_cursor,arrow_cursor;

font_obj	small_font,medium_font,large_font;

win_obj		control_win,image_win,entry_win,message_win,coord_win;
GC		image_xor_gc, image_handle_gc;

int		divs;

control_struct	control_list[NUM_CONTROLS]=
{{"Quit",QUIT_ID,0,NULL},
 {"File",FILE_ID,2,{"load","save"}},
 {"Draw mode",DRAW_MODE_ID,3,{"sel","poly","fill"}},
 {"Image mode",IMAGE_MODE_ID,2,{"image","overlay"}},
 };

int		num_control_rows,num_controls_per_row;
Coord		control_spacing;

int		reverse_p;


/*
 * open display connection
 */
setup_display()
{
  if ((display = XOpenDisplay(NULL)) == NULL) {
    fprintf(stderr,"Can't open display %s\n",XDisplayName(NULL));
    exit(1);
  }
  screen = DefaultScreen(display);
}


/* 
 * create windows, graphics contexts, etc.
 */
init_ui()
{
  Visual	*visual;
  unsigned int	background,border_color;
  int		xpos,ypos,border_width;
  int		app_width,app_height;
  Window  	rwin;
  XSizeHints	hints;
  byte		*data;
  int		i;
  extern Colormap	init_colormap();

  /* window sizes, etc. */

  border_width=4;

  image_win.width=image.width;
  image_win.height=image.height;

  control_win.height=50;
  control_win.width=image_win.width;
  num_control_rows=1;
  num_controls_per_row=NUM_CONTROLS;
  control_spacing.x=control_win.width/num_controls_per_row;
  control_spacing.y=control_win.height;       

  message_win.height=50;
  message_win.width=400;
  entry_win.width=message_win.width;

  coord_win.height=50;
  coord_win.width=entry_win.width;

  app_width=image_win.width+4+entry_win.width+4;
  app_height=control_win.height+4+image_win.height+4;

  entry_win.height=app_height- (coord_win.height+4+message_win.height+4)-4;


  /* font and cursor */

  if ((medium_font.info=XLoadQueryFont(display,"8x13"))==0) {
    fprintf(stderr,"couldn't load 8x13 font\n");
    exit(1);
  }
  medium_font.height=medium_font.info->ascent+medium_font.info->descent;
  medium_font.width=XTextWidth(medium_font.info," ",1);

  if ((small_font.info=XLoadQueryFont(display,"6x9"))==0) {
    fprintf(stderr,"couldn't load 6x9 font, using 8x13 instead\n");
    small_font.info=medium_font.info;
  }
  small_font.height=small_font.info->ascent+small_font.info->descent;
  small_font.width=XTextWidth(small_font.info," ",1);

  if ((large_font.info=XLoadQueryFont(display,"-adobe-times-bold-r-normal--14-140-75-75-p-77-iso8859-1"))==0) {
    fprintf(stderr,"couldn't load adobe-times font, using 8x13 instead\n");
    large_font.info=medium_font.info;
  }
  large_font.height=large_font.info->ascent+large_font.info->descent;
  large_font.width=XTextWidth(large_font.info," ",1);

  cross_cursor=XCreateFontCursor(display,XC_crosshair);
  arrow_cursor=XCreateFontCursor(display,XC_left_ptr);


  /* root window */

  visual=DefaultVisual(display,screen);
  border_color= 0;

  xpos=50; ypos=25;
  background=NUM_GREY_LEVELS/2;
  rwin = XCreateSimpleWindow(display,XRootWindow(display,screen),
			     xpos,ypos,app_width,app_height,
			     border_width, border_color, background);
  XStoreName(display,rwin,"Area Definitions");
  hints.flags = PPosition | PSize | USSize | USPosition ;
  XSetWMNormalHints(display,rwin,&hints);
  XMapWindow(display,rwin);

  /* colors */

  XSetWindowColormap(display,rwin,init_colormap(visual,rwin));
  divs=256/NUM_GREY_LEVELS;

  /* other windows */

  border_width=2;

  background = NUM_GREY_LEVELS-1;
  control_win.window =
    XCreateSimpleWindow(display,rwin, 0,0,
			control_win.width,control_win.height,
			border_width,border_color,background);
  gc_values.foreground=0;
  gc_values.background=background;
  gc_values.font=medium_font.info->fid;
  control_win.gc=XCreateGC(display,control_win.window,
			   GCForeground|GCBackground|GCFont,  &gc_values);
  XSelectInput(display, control_win.window, ButtonPressMask|ExposureMask);
  XMapWindow(display,control_win.window);

  message_win.window =
    XCreateSimpleWindow(display,rwin,
			control_win.width+2*border_width,0,
			message_win.width,message_win.height,
			border_width,border_color,background);
  message_win.gc=XCreateGC(display,message_win.window,
			   GCForeground|GCBackground|GCFont, &gc_values);
  XSelectInput(display, message_win.window, KeyPressMask|ExposureMask);
  XMapWindow(display,message_win.window);

  entry_win.window =
    XCreateSimpleWindow(display,rwin,
			image_win.width+2*border_width,
			message_win.height+2*border_width,
			entry_win.width,entry_win.height,
			border_width,border_color,background);
  entry_win.gc=XCreateGC(display,entry_win.window,
		     GCForeground|GCBackground|GCFont, &gc_values);
  XSelectInput(display, entry_win.window,
	       ButtonPressMask|KeyPressMask|ExposureMask);
  XMapWindow(display,entry_win.window);

  coord_win.window =
    XCreateSimpleWindow(display,rwin,
			image_win.width+2*border_width,
			message_win.height+entry_win.height+4*border_width,
			coord_win.width,coord_win.height,
			border_width,border_color,background);
  XSelectInput(display, coord_win.window, ExposureMask);
  coord_win.gc=XCreateGC(display,coord_win.window,
			 GCForeground|GCBackground|GCFont, &gc_values);
  XMapWindow(display,coord_win.window);

  background=0;

  image_win.window =
    XCreateSimpleWindow(display,rwin,
			0, control_win.height+2*border_width,
			image_win.width,image_win.height,
			border_width,border_color,background);
  XDefineCursor(display,image_win.window,arrow_cursor);
  gc_values.foreground=1;
  image_win.gc=XCreateGC(display,image_win.window,GCForeground, &gc_values);
  gc_values.foreground=BLUE;
  image_handle_gc=XCreateGC(display,image_win.window,GCForeground, &gc_values);
  gc_values.plane_mask=NUM_GREY_LEVELS;
  gc_values.function=GXxor;
  gc_values.foreground=DRAW;
  image_xor_gc=XCreateGC(display,image_win.window,
			 GCPlaneMask|GCFunction|GCForeground, &gc_values);
  XSelectInput(display, image_win.window, KeyPressMask|ButtonPressMask|
	       ButtonReleaseMask|PointerMotionMask|LeaveWindowMask|
	       ExposureMask);
  XMapWindow(display,image_win.window);

  /* ximage structs */

  ximage =XCreateImage(display,visual,8,ZPixmap,0,image.data,
		       image.width,image.height,8,0);

  /* init images */

  for (i=0; i<image.nrc; i++) {
    image.data[i] /= divs;
    if (image.overlay)
      image.overlay[i] /= divs;
  }
}

Colormap init_colormap(visual,win)
Visual	*visual;
Window	win;
{
  int		i,j,shift,index,range;
  Colormap	cmap;
  XColor 	color[256];

  cmap=XCreateColormap(display,win,visual,AllocAll);
  shift=8+2;
  for (i=0; i<NUM_GREY_LEVELS; i++) {
    color[i].pixel = i;
    color[i].red   = i<<shift;
    color[i].green = i<<shift;
    color[i].blue  = i<<shift;
    color[i].flags = DoRed | DoGreen | DoBlue;
  }
  for (i=NUM_GREY_LEVELS; i<2*NUM_GREY_LEVELS; i++) {
    color[i].pixel = i;
    color[i].red   = 255*256;
    color[i].green = 0;
    color[i].blue  = 0;
    color[i].flags = DoRed | DoGreen | DoBlue;
  }
  index=2*NUM_GREY_LEVELS;

  for (j=0; j<NUM_COLORS; j++) {
    for (i=0; i<NUM_GREY_LEVELS_PER_COLOR; i++) {
      color[index].pixel = index;
      color[index].red   = (256*i*my_red(j))/(NUM_GREY_LEVELS_PER_COLOR-1);
      color[index].green = (256*i*my_green(j))/(NUM_GREY_LEVELS_PER_COLOR-1);
      color[index].blue  = (256*i*my_blue(j))/(NUM_GREY_LEVELS_PER_COLOR-1);
      color[index].flags = DoRed | DoGreen | DoBlue;
      index++;
    }
  }

  XStoreColors(display,cmap,color,256);
  return(cmap);
}

/*
 * color scheme used by Matt Wilson's xview program
 */
#include <math.h>
#define WI ((double)NUM_COLORS/2-0.5)
#define	arc(x)	(255.0*sqrt(1.0-(((x)-WI)/WI)*(((x)-WI)/WI)))
#define	carc(x)	(((0<=(x))&&((x)<= 2*WI ))?arc(x):0)

my_red(i)
int	i;
{
  return((int)carc((double)(i-WI)));
}

my_green(i)
int	i;
{
  return((int)carc((double)(i)));
}

my_blue(i)
int	i;
{
  return((int)carc((double)i+WI));
}

