/*
 * object manipulation
 *
 * Copyright 1994, Bruno Olshausen and Bill Press
 * Washington University School of Medicine
 *
 */ 

#include <stdio.h>
#include "mk_areas.h"
#include "ui.h"
#include "ui_objects.h"

XPoint	move_org,bar[MAX_NUM_POLYGON_VERTICES];
int	move_mode=NULL_MODE;
int	draw_mode=SELECTION_MODE;
int	current_handle=NO_HANDLE;
int	polygon_finished_p=0;
int	draw_fill_p=0;


/* interactive drawing stuff */

set_draw_mode(mode)
int	mode;
{
  if (mode==DRAW_FILL_MODE) {
    draw_fill_p = !draw_fill_p;
    redraw_image_win();
  }
  else
    draw_mode=mode;
}


drawing_press_action(x,y,b)
int	x,y;
{
  switch (draw_mode) {
  case SELECTION_MODE:
    process_selection_press(x,y);
    break;
  case DRAW_POLYGON_MODE:
    process_polygon_press(x,y,b);
    break;
  }
}

process_selection_press(x,y)
int	x,y;
{
  Area		*area;
  extern Area	*which_area();

  if (current_handle!=NO_HANDLE) {
    draw_handle_bars(selected_area);
    move_mode=STRETCH_MODE;
  }
  else if (area=which_area(x,y)) {
    select_area(area);
    set_pos(&move_org,x,y);
    move_mode=MOVE_OBJECT_MODE;
  }
  else {
    if (selected_area)
      select_area(NULL);
  }
}

Area *which_area(x,y)
int	x,y;
{
  Area	*area;

  area=area_list;

  while (area) {
    if (within_object_p(area->object,x,y))
      return(area);
    area=area->next;
  }
  return(0);
}

within_object_p(obj,x,y)
Object	*obj;
int	x,y;
{
  return(within_polygon_p(obj,x,y));
}

select_area(area)
Area	*area;
{
  deselect_area();
  selected_area=area;
  redraw_entry_win();
}

deselect_area()
{
  if (selected_area) {
    draw_handle_bars(selected_area);
    selected_area=NULL;
  }
  redraw_entry_win();
}


new_area(x,y)
int	x,y;
{
  Area	*new_area;

  new_area=(Area *)calloc(1,sizeof(Area));
  new_area->object=(Object *)calloc(1,sizeof(Object));
  new_area->next=area_list;
  area_list=new_area;

  init_area_label(new_area);
  init_polygon(new_area->object,x,y);

  select_area(new_area);
  draw_object(new_area->object);
}

init_area_label(area)
Area *area;
{
  area->name[0]='\0';
}

drawing_move_action(x,y)
int	x,y;
{
  switch (draw_mode) {
  case SELECTION_MODE:
    process_selection_move(x,y);
    break;
  case DRAW_POLYGON_MODE:
    if (move_mode==STRETCH_MODE  && !polygon_finished_p)
      process_polygon_drawing_move(selected_area->object,x,y);
    break;
  }
}

process_selection_move(x,y)
int	x,y;
{
  switch (move_mode) {
  case NULL_MODE:
    if (selected_area)
      check_within_handles(x, y);
    break;
  case MOVE_OBJECT_MODE:
    move_area(x,y);
    break;
  case STRETCH_MODE:
    stretch_area(x,y);
    break;
  }
}

check_within_handles(x,y)
int	x,y;
{
  static int	currently_in_handles_p=0;

  if ((current_handle=which_handle(x,y))!=NO_HANDLE) {
    if (!currently_in_handles_p) {
      XDefineCursor(display,image_win.window,cross_cursor);
      currently_in_handles_p=1;
    }
  }
  else {
    if (currently_in_handles_p) {
      XDefineCursor(display,image_win.window,arrow_cursor);
      currently_in_handles_p=0;
    }
  }
}

which_handle(x,y)
int	x,y;
{
  register int	i,num_handle_bars;
  static XPoint	bar_size={BAR_SIZE,BAR_SIZE};

  num_handle_bars = num_polygon_handles(selected_area->object);

  for (i=0; i<num_handle_bars; i++) {
    if (in_region_p(&bar[i],&bar_size,x,y))
      return(i);
  }
  return(NO_HANDLE);
}

move_area(x,y)
int	x,y;
{
  XPoint	delta;

  diff_pos(&delta,&move_org,x,y);
  draw_object(selected_area->object);
  inc_polygon_pos(selected_area->object,&delta);
  draw_object(selected_area->object);
  set_pos(&move_org,x,y);
}

stretch_area(x,y)
int	x,y;
{
  stretch_polygon(selected_area->object,x,y,current_handle);
}    
    

drawing_release_action()
{
  switch (draw_mode) {
  case SELECTION_MODE:
    if (selected_area)
      let_go_selected_area();
    break;
  case DRAW_POLYGON_MODE:
    if (polygon_finished_p)
      let_go_selected_area();
    break;
  }
}

let_go_selected_area()
{
  set_handle_bars(selected_area);
  draw_handle_bars(selected_area);
  draw_mode=SELECTION_MODE;
  move_mode=NULL_MODE;
}

set_handle_bars(Area *area_ptr)
{
  set_polygon_handle_bars(area_ptr->object);
}


draw_object(obj)
Object	*obj;
{
  draw_polygon(obj);
}

draw_handle_bars(Area *area_ptr)
{
  int	i,num_handle_bars;

  num_handle_bars =  num_polygon_handles(area_ptr->object);

  for (i=0; i<num_handle_bars; i++)
    XFillRectangle(display,image_win.window,image_xor_gc,
		   bar[i].x,bar[i].y,BAR_SIZE,BAR_SIZE);
}

draw_all_handle_bars()
{
  static int all_drawn=0;

  int	i, num_handle_bars;
  Area	*area_ptr = area_list;

  refresh_data_displays();

  if (!all_drawn)
    while (area_ptr) {
      set_handle_bars(area_ptr);
      num_handle_bars =  num_polygon_handles(area_ptr->object);
      for (i=0; i<num_handle_bars; i++)
	XFillRectangle(display,image_win.window,image_handle_gc,
		       bar[i].x,bar[i].y,BAR_SIZE,BAR_SIZE);
      area_ptr=area_ptr->next;
    }

  if (selected_area)
    set_handle_bars(selected_area);

  all_drawn = (all_drawn+1)%2;
}

delete_area()
{
  Area	*area;

  if (selected_area) {
    draw_handle_bars(selected_area);
    draw_object(selected_area->object);

    area=area_list;

    if (area==selected_area)
      area_list=selected_area->next;
    else {
      while (area->next != selected_area)
	area=area->next;
      area->next=selected_area->next;
    }
    free(selected_area);
    selected_area=NULL;

    if (current_handle!=NO_HANDLE) {
      XDefineCursor(display,image_win.window,arrow_cursor);
      current_handle=NO_HANDLE;
    }

    redraw_entry_win();
  }
}


/* routines for manipulating coordinates */

in_region_p(org,size,x,y)
XPoint	*org,*size;
int	x,y;
{
  register int	diffx,diffy;

  diffx=x-org->x;
  diffy=y-org->y;
  if ((diffx>=0) && (diffx<=size->x) && (diffy>=0) && (diffy<=size->y))
    return(1);
  else
    return(0);
}

set_pos(pos,x,y)
XPoint	*pos;
int	x,y;
{
  pos->x=x-x%ICON_SF;
  pos->y=y-y%ICON_SF;
}

set_pos_handle_bars(pos,x,y)
XPoint	*pos;
int	x,y;
{
  pos->x=x;
  pos->y=y;
}

diff_pos(delta,pos,x,y)
XPoint	*delta,*pos;
int	x,y;
{
  delta->x=x-x%ICON_SF-pos->x;
  delta->y=y-y%ICON_SF-pos->y;
}

inc_pos(pos,delta)
XPoint	*pos,*delta;
{
  pos->x+=delta->x;
  pos->y+=delta->y;
}
