/* 
 * polygon drawing
 *
 * Copyright 1994, Bruno Olshausen
 * Washington University School of Medicine
 *
 */

#include <stdio.h>
#include "mk_areas.h"
#include "ui.h"
#include "ui_objects.h"
#include <X11/Xutil.h>

init_polygon(poly,x,y)
Polygon *poly;
int	x,y;
{
  set_pos(&(poly->points[0]),x,y);
  set_pos(&(poly->points[1]),x,y);
  poly->num_points=2;
}

inc_polygon_pos(poly,d)
Polygon	*poly;
XPoint	*d;
{
  register int	i;

  for (i=0; i<poly->num_points; i++)
    inc_pos(&(poly->points[i]),d);
}

within_polygon_p(poly,x,y)
Polygon	*poly;
int	x,y;
{
  static Region	r=NULL;

  if (r)
    XDestroyRegion(r);

  r=XPolygonRegion((XPoint *)poly->points,poly->num_points,WindingRule);
  return(XPointInRegion(r,x,y));
}


process_polygon_press(x,y,b)
int	x,y,b;
{
  switch (move_mode) {
  case NULL_MODE:
    new_area(x,y);
    move_mode=STRETCH_MODE;
    polygon_finished_p=0;
    break;
  case STRETCH_MODE:
    add_polygon_point(selected_area->object,x,y,b);
    break;
  }
}

add_polygon_point(poly,x,y,b)
Polygon	*poly;
int	x,y,b;
{
  switch (b) {
  case Button1:
    set_pos(&(poly->points[poly->num_points-1]),x,y);
    set_pos(&(poly->points[poly->num_points++]),x,y);
    break;
  case Button3:
    draw_polygon(poly);
    set_pos(&(poly->points[poly->num_points-1]),
	    poly->points[0].x,poly->points[0].y);
    draw_polygon(poly);
    polygon_finished_p=1;
    break;
  }  
}


process_polygon_drawing_move(poly,x,y)
Polygon	*poly;
int	x,y;
{
  stretch_polygon(poly,x,y,poly->num_points-1);
}

stretch_polygon(poly,x,y,i)
Polygon	*poly;
int	x,y,i;
{
  draw_polygon(poly);
  set_pos(&(poly->points[i]),x,y);
  if (i==0)
    set_pos(&(poly->points[poly->num_points-1]),x,y);
  draw_polygon(poly);
}


draw_polygon(poly)
Polygon *poly;
{
  XPoint	lpoints[MAX_NUM_POLYGON_VERTICES];
  register int	i;

  for (i=0; i<poly->num_points; i++) {
    lpoints[i].x= poly->points[i].x;
    lpoints[i].y=poly->points[i].y;
  }

  if (!draw_fill_p)
    XDrawLines(display,image_win.window,image_xor_gc,
	       lpoints,poly->num_points,CoordModeOrigin);
  else
    XFillPolygon(display,image_win.window,image_xor_gc,
		 lpoints,poly->num_points,Nonconvex,CoordModeOrigin);
}


set_polygon_handle_bars(poly)
Polygon	*poly;
{
  int	i;

  for (i=0; i<poly->num_points-1; i++)
    set_pos_handle_bars(&bar[i],poly->points[i].x-BAR_SIZE/2,
			poly->points[i].y-BAR_SIZE/2);
}


num_polygon_handles(poly)
Polygon	*poly;
{
  return(poly->num_points-1);
}
