/*
 * routines for defining areas, computing overlaps, area list management
 *
 * Copyright 1994, 1995 Bruno Olshausen and Bill Press
 * Washington University School of Medicine
 *
 */

#include <stdio.h>
#include <malloc.h>
#include <fcntl.h>

#include "xanat.h"


AreaDef *check_new_area(name, list)
    char	*name;
    AreaDef	*list;
{
  AreaDef	*aptr;

  aptr=list;
  while (aptr) {
    if (strcmp(name, aptr->name)==0)
      return(aptr);
    aptr=aptr->next;
  }
  return(NULL);
}


/*
 * convert search list names to objects
 */
search_list2objects(area_name_list, objects)
    char	*area_name_list;
    Object	**objects;
{
  int		i,j;
  char    area_names[100][20];
  AreaDef *aptr;
  Object	*obj, *new_object;

  parseString(area_names, area_name_list);

  for (i=0; i<num_images; i++) {
    freeObject(objects[i]);
    objects[i]=NULL;
  }

  for (i=0; *area_names[i]!='\0'; i++) {

    if (area_names[i][0]=='+')
      scoot (area_names[i]);

    aptr=area_list;
    while(aptr) {
      if (strcmp(aptr->name, area_names[i]) == 0) {
	for (j=0; j<num_images; j++) {
	  obj=aptr->objects[j];
	  while (obj) {
	    new_object = (Object *) calloc (1, sizeof(Object));
	    MCHECK(new_object);
	    copy_object(new_object, obj);
	    new_object->header.next=objects[j];
	    objects[j]=new_object;
	    obj=obj->header.next;
	  }
	}
      }
      aptr=aptr->next;
    }
  }
}


/*
 * convert area_name to object
 */
area_name2object(area_name, objects)
    char	*area_name;
    Object	**objects;
{
  int		j;
  AreaDef	*aptr;
  Object	*obj, *new_object;

  aptr=area_list;
  while(aptr) {
    if (strcmp(aptr->name, area_name) == 0) {
      obj=aptr->objects[current_image];
      while (obj) {
	new_object = (Object *) calloc (1, sizeof(Object));
	MCHECK(new_object);
	copy_object(new_object, obj);
	new_object->header.type=object_mode;
	new_object->header.inj_num=inject_num;
	new_object->header.strength=strength_num;
	new_object->header.next=objects[current_image];
	objects[current_image]=new_object;
	obj=obj->header.next;
      }
    }
    aptr=aptr->next;
  }
}


/*
 * Compute areas corresponding to a datum's object list
 */
update_datum_areas()
{
  compute_areas(selected_datum[view_mode]);
  redraw_data_win();
}


compute_areas(datum)
    Datum	*datum;
{
  extern Area	*objects2area_list();

  if (datum->type==DATA_TYPE) {
    freeArea(datum->injAreas);
    datum->injAreas=objects2area_list(datum->objects,INJECTION);
    freeArea(datum->labelAreas);
    datum->labelAreas=objects2area_list(datum->objects,LABEL);
  }
  else {
    freeArea(datum->injAreas);
    datum->injAreas=objects2area_list(datum->objects,SEARCH_AREA);
  }    
}

Area *objects2area_list(objects,mode)
    Object	**objects;
    int	mode;
{
  int		i, overlap;
  Area		*datum_areas, *new_datum_area, *existing_area;
  Object	*datum_obj, *area_obj;
  AreaDef	*aptr;
  Box		area_box;
  extern Area	*check_new_datum_area();
  extern Object	*object_exists();

  datum_areas=NULL;

  for (i=0; i<num_images; i++) {
    if (datum_obj=object_exists(objects[i],mode)) {
      draw_object_list_in_icon_pixmap(datum_obj,mode,NUM_DIFF_INJ,1,1);
      get_data_ximage();
      aptr=area_list;
      while(aptr) {
	area_obj=aptr->objects[i];
	overlap=0;
	while (area_obj) {
	  compute_object_icon_bounding_box(area_obj,&area_box);
	  if (objects_within_bounding_box_p(datum_obj,&area_box)) {
	    draw_object_in_icon_pixmap(area_obj,1);
	    get_search_ximage();
	    overlap+=region_overlap(&area_box);
	  }
	  area_obj=area_obj->header.next;
	}
	if (overlap!=0) {
	  if (existing_area=check_new_datum_area(aptr->name, datum_areas)) {
	    existing_area->fract+=(100*overlap)/aptr->size;
	  }
	  else {
	    new_datum_area=(Area *)calloc(1,sizeof(Area));
	    MCHECK(new_datum_area);
	    strcpy(new_datum_area->name, aptr->name);
	    new_datum_area->fract=(double)(100.0*overlap)/aptr->size;
	    new_datum_area->next=datum_areas;
	    datum_areas=new_datum_area;
	  }
	}
	aptr=aptr->next;
      }
    }
  }
  return(datum_areas);
}

Area *check_new_datum_area(name, list)
    char	*name;
    Area	*list;
{
  Area	*aptr;

  aptr=list;
  while (aptr) {
    if (strcmp(name, aptr->name)==0)
      return(aptr);
    aptr=aptr->next;
  }
  return(NULL);
}

compute_area_sizes() /* compute sizes of each area in area_list */
{
  int		size,i;
  Object	*obj;
  AreaDef	*aptr;
  
  aptr=area_list;
  while(aptr) {
    size=0;
    for (i=0; i<num_images; i++) {
      obj=aptr->objects[i];
      while (obj) {
	size += (obj->header.size=object_size(obj));
	obj=obj->header.next;
      }
    }
    aptr->size=size;
    aptr=aptr->next;
  }
}

int is_an_area (Object *obj)
{
  AreaDef	*aptr = area_list;
  Object	*ao_ptr;

  if (obj->header.shape==1)
    while (aptr) {
      ao_ptr = aptr->objects[current_image];
      while (ao_ptr) {
	if (compare_objects(ao_ptr, obj))
	  return (1);
	ao_ptr = ao_ptr->header.next;
      }
      aptr = aptr->next;
    }
  return (0);
}

process_area_press(x,y)
    int x,y;
{
  Object	*obj, *next_obj, *ao_ptr;
  AreaDef	*aptr = area_list;
  int		removed_area = 0;
  int		added_area = 0;

  obj=selected_datum[view_mode]->objects[current_image];
  while (obj != NULL) {
    next_obj = obj->header.next;
    if (within_object_p(obj,x,y) && obj->header.inj_num==inject_num &&
	is_an_area(obj)) {
      remove_object_from_datum_list (obj, selected_datum[view_mode]);
      removed_area = 1;
    }
    obj=next_obj;
  }
	
  if (removed_area == 0)
    while(aptr) {
      ao_ptr = aptr->objects[current_image];
      while (ao_ptr)
	if (within_object_p(ao_ptr,x,y)) {
	  area_name2object(aptr->name, selected_datum[view_mode]->objects);
	  added_area = 1;
	  ao_ptr = NULL;
	}
	else
	  ao_ptr = ao_ptr->header.next;
      aptr = aptr->next;
    }

  if (removed_area || added_area) {
    update_datum_areas();
    refresh_data_displays();
  }
  else
    perr("No area defined at cursor location");
}
