/*
 * database control functions
 *
 * Copyright 1994, 1995 Bill Press and Bruno Olshausen
 * Washington University School of Medicine
 *
 */

#include <stdio.h>
#include <malloc.h>

#include "xanat.h"

select_datum(Datum *dptr)
{
  deselect_object();
  selected_datum[view_mode] = dptr;
  if (dptr)
    analysis_type = dptr->analysisMethod;
  refresh_data_displays();
}

/*
 * Icon window routine
 */

select_image(image_num)
    int	image_num;
{
  current_image=image_num;
  redraw_image_win(1);
}


/*
 * Image window routine (not object-related)
 */

toggle_valid_flag()
{
  selected_datum[view_mode]->validSlice[current_image]=
    !selected_datum[view_mode]->validSlice[current_image];

  redraw_icon(current_image);
  redraw_image_win(0);

  if (selected_datum[view_mode]->validSlice[current_image])
    pmes("Made slice valid for editing and analysis.");
  else
    pmes("Made slice invalid for editing and analysis.");
}


/*
 * Index window routines
 */

datum_select(index)
    int	index;
{
  Datum	*dptr, *next;
  int	i;
  char *ch;
  extern char		*query();

  index+=index_page[view_mode]*num_datums_per_index_page;
  dptr=list[view_mode];
  for (i=0; i<index && dptr; i++) {
    if ((next=dptr->next[view_mode])==NULL)
      break;
    else
      dptr=next;
  }
  if (dptr == selected_datum[view_mode])
    if (dptr->type!=ANALYSIS_TYPE) {
      dptr->writeProtect = (dptr->writeProtect+1)%2;
      if (dptr->writeProtect) {
	ch=query("Write-protecting: save changes to file? ");
	if (*ch=='y' || *ch=='Y')
	  if (do_save()==-1)
	    return -1;
      }
      else
	pmes("Removed write protection");
      redraw_index_win();
    }
    else
      perr("Cannot write protect analysis records");
  else
    select_datum(dptr);
}

datum_list_step_up()
{
  Datum	*datum;

  if (selected_datum[view_mode]) {
    datum=selected_datum[view_mode]->prev[view_mode];
    if (datum) {
      index_page[view_mode]=index_page_of_datum(datum);
      select_datum(datum);
    }
  }
}

datum_list_step_down()
{
  Datum	*datum;

  if (selected_datum[view_mode]) {
    datum=selected_datum[view_mode]->next[view_mode];
    if (datum) {
      index_page[view_mode]=index_page_of_datum(datum);
      select_datum(datum);
    }
  }
}


index_page_up()
{
  if (index_page[view_mode])
    index_page[view_mode]--;
  redraw_index_win();
}

index_page_down()
{
  index_page[view_mode]++;
  redraw_index_win();
}

Datum *repage_index()
{
  Datum	*dptr, *index_start;
  int	i,j;

  dptr=index_start=list[view_mode];
  for (i=0; i<=index_page[view_mode] && dptr; i++) {
    index_start=dptr;
    for (j=0; j<num_datums_per_index_page && dptr; j++)
      dptr=dptr->next[view_mode];
  }
  if (index_page[view_mode]=i)
    index_page[view_mode]--;
  return (index_start);
}

index_page_of_datum(datum)
    Datum	*datum;
{
  int	i,j;
  Datum	*dptr;

  dptr=list[view_mode];
  i=0;
  while(dptr) {
    for (j=0; j<num_datums_per_index_page; j++) {
      if (dptr==datum)
	return(i);
      dptr=dptr->next[view_mode];
    }
    i++;
  }
}



/*
 * Control window routines
 */

/* List button */

add_delete_list(add_delete)
    int	add_delete;
{
  int		type;
  Datum		*new_datum, *next_datum, *remove_datum;
  extern Datum	*remove_from_list();

  char	line[80];

  if (view_mode==DATA)
    type=DATA_TYPE;
  else if (view_mode==ANALYSIS)
    type=ANALYSIS_TYPE;
  else {
    perr("Enter data or analysis mode to add or delete records");
    return;
  }

  if (add_delete==ADD) {
    new_datum=(Datum *)calloc(1,sizeof(Datum));
    MCHECK(new_datum);
    init_datum(new_datum,type);
    if (list[view_mode])
      add_to_list(new_datum,selected_datum[view_mode],view_mode);
    else
      list[view_mode]=new_datum;
    renum_refs(view_mode);
    index_page[view_mode]=index_page_of_datum(new_datum);
    select_datum(new_datum);
    if (is_analysis)
      pmes("Added analysis datum");
    else
      pmes("Added injection datum");
  }
  else {
    if (remove_datum=selected_datum[view_mode])
      if (!remove_datum->writeProtect) {
	if (next_datum = remove_from_list(remove_datum, view_mode))
	  index_page[view_mode]=index_page_of_datum(next_datum);
	if (!next_datum && view_mode==ANALYSIS) {
	  next_datum=list[ANALYSIS]=(Datum *)calloc(1,sizeof(Datum));
	  MCHECK(next_datum);
	  init_datum(next_datum,ANALYSIS_TYPE);
	}
	renum_refs(view_mode);
	redo_compare_refs(remove_datum);
	select_datum(next_datum);
	if (is_analysis)
	  pmes("Removed analysis datum");
	else
	  pmes("Removed injection datum");
      }
      else {
	sprintf(line,"Click \">%s\" to remove write-protection",
		selected_datum[view_mode]->ref.abbrev);
	perr(line);
      }
    else
      perr("No datum to delete");
  }
}

/* Stack button */

add_delete_stack(add_delete)
    int			add_delete;
{
  Datum		*next_datum, *remove_datum;

  extern int	stack_check();
  extern Datum	*remove_from_list();

  if (add_delete==ADD) {
    if (selected_datum[view_mode]) {
      if (stack_check(selected_datum[view_mode])) {
	add_to_list_top(selected_datum[view_mode], STACK);
	pmes("Pushed record onto stack");
      }
      else {
	moveToStackTop(selected_datum[view_mode]);
	pmes("Moved record to top of stack");
      }
      selected_datum[STACK]=list[STACK];
      redraw_index_win();
    }
    else
      perr("No datum selected to add or move");
  }
  else {
    if (view_mode!=STACK) {
      perr("Must be in stack mode to delete from stack");
      return;
    }
    if (remove_datum=selected_datum[STACK]) {
      if (remove_datum->type==ANALYSIS_TYPE &&
	  remove_datum->analysisMethod>=COMPARE_OFFSET) {
	if (remove_datum->prev[STACK])
	  next_datum=remove_datum->prev[STACK];
	else
	  next_datum=remove_datum->next[STACK];
	remove_from_list(remove_datum,COMPARE);
	renum_refs(COMPARE);
	redo_compare_refs(remove_datum);
      }
      else
	next_datum=remove_from_list(remove_datum,STACK);
      if (next_datum)
	index_page[STACK]=index_page_of_datum(next_datum);
      select_datum(next_datum);
      pmes("Removed datum from stack");
    }
    else
      perr("Nothing on the stack");
  }
}


compare_heatmaps(int compare_action)
{
  Datum	*new_datum;
  int	num_analyses;

  compare_action+=COMPARE_OFFSET;
  if (list[STACK] && list[STACK]->next[STACK]) {
    num_analyses = list[STACK]->type + list[STACK]->next[STACK]->type;
    if (num_analyses)
      if (num_analyses==2 || compare_action==ADDITION) {
	new_datum=(Datum *)calloc(1,sizeof(Datum));
	MCHECK(new_datum);
	init_datum(new_datum,ANALYSIS_TYPE);
	if (num_analyses==1)
	  add_data_into_heatmap(list[STACK], list[STACK]->next[STACK],
				new_datum);
	else
	  do_heatmap_comparison(list[STACK], list[STACK]->next[STACK],
				new_datum, compare_action);
	new_datum->analysisMethod=compare_action;
	new_datum->compareFrom1=list[STACK];
	new_datum->compareFrom2=list[STACK]->next[STACK];
	analysis2abbrev(new_datum);
	add_to_list(new_datum,list[STACK]->next[STACK],STACK);
	add_to_list_bottom(new_datum,COMPARE);
	renum_refs(COMPARE);
	select_datum(new_datum);
      }
      else
	perr("Can only add data to heatmap");
    else
      perr("Must use at least one heatmap in comparison");
  }
  else
    perr("Must have two records in stack");
}


/* Analysis button */

do_analysis(direction)
    int	direction;
{
  Datum	*datum;
  int	result;

  datum=selected_datum[view_mode];
  if (datum)
    if (datum->type==ANALYSIS_TYPE) {
      datum->analysis_midpoint=0;
      if (analysis_type==SUPERPOSITION)
	result = analyzeSuperpos(datum, list[DATA], direction);
      else if (analysis_type==BAYES)
	result = analyzeBayes(datum, list[DATA], direction);
      else {
	perr("Select an analysis method");
	return;
      }
      if (result==-1)
	return;
      datum->analysisMethod=analysis_type;
      analysis2abbrev(datum);
      get_refs_from_search_list(datum->ref.full);
      selected_datum[SEARCH]=list[SEARCH];
      refresh_data_displays();
      pmes("Analysis done");
    }
    else
      perr("Select analysis datum (try View mode)");
  else
    perr("Select analysis datum (try View mode)");
}

/* File button */

do_save()
{
  char			line[80],filename[80],*answer;
  extern char		*query();

  answer=query("Save to file: ");
  strcpy(filename,answer);
  if (strlen(filename)==0) {
    perr("Filename must contain at least one character");
    return -1;
  }
  if (writeData(list[DATA],filename,0)!=-1) {
    sprintf(line,"Saved to file: %s",filename);
    pmes(line);
  } else {
    sprintf(line,"Problem in saving to file: %s",filename);
    perr(line);
    return -1;
  }
}

int find_max_inj_num(Datum *data)
{
  int		plane;
  int		max_inj_num=0;
  Datum		*currentDatum;
  Object	*currentObject;

  for (currentDatum=data; currentDatum!=NULL;
       currentDatum=currentDatum->next[DATA])
    for (plane=0; plane<num_images; plane++)
      for (currentObject=currentDatum->objects[plane];
	   currentObject!=NULL; currentObject=currentObject->header.next)
	if (currentObject->header.inj_num > max_inj_num)
	  max_inj_num = currentObject->header.inj_num;
  return (max_inj_num);
}

file_handling(load_save)
    int	load_save;
{
  int		max_inj_num;
  char		line[80],filename[80],*answer;
  Datum		*new_list,*loop_ptr,*tmp_ptr;
  extern Datum	*readData();
  extern char	*query();

  if (load_save==LOAD) {
    answer=query("Load file: ");
    strcpy(filename,answer);
    if (strlen(filename)==0) {
      perr("Filename must contain at least one character");
      return;
    }
    if ((new_list=readData(filename))==NULL) {
      sprintf(line,"Problem in reading file: %s",filename);
      perr(line);
      return;
    }
    if ((max_inj_num=find_max_inj_num(new_list))>=NUM_DIFF_INJ) {
      sprintf(line,"Recompile Xanat with %d colors",max_inj_num);
      perr(line);
      return;
    } 
    if (!list[DATA]) {
      list[DATA]=new_list;
    } else {
      answer=query("Append or replace current data (a/r)? ");
      if (*answer=='r') {
	loop_ptr=list[DATA];
	while (loop_ptr) {
	  tmp_ptr=loop_ptr->next[DATA];
	  freeDatum(loop_ptr);
	  loop_ptr=tmp_ptr;
	}
	list[DATA]=new_list;
      } else {
	loop_ptr=list[DATA];
	while (loop_ptr->next[DATA])
	  loop_ptr=loop_ptr->next[DATA];
	loop_ptr->next[DATA]=new_list;
	new_list->prev[DATA]=loop_ptr;
      }
    }
    renum_refs(DATA);
    selected_datum[DATA] = list[DATA];
    set_view_mode(DATA);
    sprintf(line,"Loaded file: %s",filename);
    pmes(line);
  } else
    do_save();
}


/* Analysis mode button */

set_analysis_method(method)
    int	method;
{
  analysis_type = method;
  redraw_control_win();
}


/* Image mode button */

set_image_mode(mode)
    int	mode;
{
  image_mode=mode;
  refresh_data_displays();
}

byte *get_image(image)
    Image	*image;
{
  if (image_mode==IMAGE)
    return(image->data);
  else if (image->overlay)
    return(image->overlay);
  else
    return(image->data);
}

/* Injection/label mode button */

set_inj_or_label_mode(mode)
    int	mode;
{
  if (selected_datum[view_mode]) {
    if (selected_datum[view_mode]->type==DATA_TYPE) {
      object_mode=mode;
      if (selected_object) {
	selected_object->header.type=mode;
	update_datum_areas();
	redraw_icon(current_image);
	redraw_data_win();
      }
      set_image_win_colors();
    }
    else
      perr("Cannot change mode for analysis records");
  }
  else {
    object_mode=mode;
    set_image_win_colors();
  }
}

/* Injection type button */

set_injection_type(int inj_num)
{
  if (selected_datum[view_mode]) {
    if (selected_datum[view_mode]->type==DATA_TYPE) {
      inject_num=inj_num;
      if (selected_object) {
	selected_object->header.inj_num=inj_num;
	redraw_icon(current_image);
      }
      if (!inject_toggles[inj_num]) {
	inject_toggles[inj_num]=1;
	refresh_data_displays();
      }
      else
	set_image_win_colors();
    }
    else
      perr("Cannot select injection for analysis records");
  }
  else {
    inject_num=inj_num;
    set_image_win_colors();
    inject_toggles[inj_num]=1;
  }
}

toggle_injection(int inj_num)
{
  if (inject_num==inj_num && !is_analysis)
    perr("Cannot hide selected injection type");
  else {
    inject_toggles[inj_num] = (inject_toggles[inj_num]+1)%2;
    if (!is_analysis && selected_datum[view_mode]) {
      update_datum_areas();
      refresh_data_displays();
    }
  }
}
/* Inj/label weight button */

set_label_weight(int strength)
{
  if (selected_datum[view_mode]) {
    if (selected_datum[view_mode]->type==DATA_TYPE) {
      strength_num=strength;
      if (selected_object) {
	if (object_is_in_front(selected_object)) {
	  draw_object(selected_object);
	  selected_object->header.strength=strength;
	  set_xor_stipple();
	  draw_object(selected_object);
	  redraw_icon(current_image);
	}
	else {
	  selected_object->header.strength=strength;
	  set_xor_stipple();
	  redraw_image_win(0);
	  redraw_icon(current_image);
	}
      }
      else
	set_xor_stipple();
    }
    else
      perr("Cannot change strength for analysis records");
  }
  else {
    strength_num=strength;
    set_xor_stipple();
  }
}

/* View mode button */

set_view_mode(mode)
    int	mode;
{
  deselect_object();
  view_mode=mode;
  if (view_mode==STACK)
    is_stack=1;
  else
    is_stack=0;
  refresh_data_displays();
  redraw_control_win();
}


/* Draw mode button */

set_draw_mode(mode)
    int	mode;
{
  char *answer;
  extern char *query();

  switch (mode) {
   case DRAW_FILL_MODE:
    fill_mode = !fill_mode;
    redraw_image_win(0);
    break;
   case REVERSE_MODE:
    if (!is_analysis) {
      reverse_mode = !reverse_mode;
      reverse_everything();
    }
    else
      perr("Cannot reverse images for analyses");
    break;
   case DRAW_ELLIPSE_MODE:
   case DRAW_POLYGON_MODE:
   case DRAW_AREA_MODE:
    deselect_object();
   case SELECTION_MODE:
    draw_mode=mode;
    break;
  }
}

/* Quit button */

quit_p()
{
  char		*ch;
  extern char	*query();

  ch=query("Are you sure you want to quit now? ");
  if (*ch=='y' || *ch=='Y')
    return(1);
  else
    return(0);
}


/*
 * Keeping track of mode variables when switching between
 * injection and analysis records
 */

int check_analysis_mode()
{
  if (view_mode==STACK && selected_datum[view_mode])
    if (selected_datum[view_mode]->type==ANALYSIS_TYPE)
      return 1;
  if (view_mode==ANALYSIS)
    return 1;
  return 0;
}

check_switch_modes()
{
  static int last_mode_used = DATA;
  static int pre_analysis_fill_mode = 0;
  static int pre_analysis_object_mode = INJECTION;
  static int pre_analysis_reverse_mode = 0;
  static int pre_analysis_strength_num = 2;
  static int pre_analysis_inject_num = 0;

  is_analysis = check_analysis_mode();

  if (!is_analysis && last_mode_used==ANALYSIS) {
    last_mode_used = view_mode;
    fill_mode = pre_analysis_fill_mode;
    object_mode = pre_analysis_object_mode;
    strength_num = pre_analysis_strength_num;
    inject_num = pre_analysis_inject_num;
    set_xor_stipple();
    set_xor_mask();
    inject_toggles[inject_num]=1;
    set_colormap_data();
    redraw_control_win();
    if (reverse_mode = pre_analysis_reverse_mode)
      reverse_everything();
  }

  if (is_analysis && last_mode_used!=ANALYSIS) {
    last_mode_used = ANALYSIS;
    pre_analysis_fill_mode = fill_mode;
    fill_mode = 1;
    pre_analysis_object_mode = object_mode;
    object_mode = SEARCH_AREA;
    pre_analysis_strength_num = strength_num;
    strength_num = (NUM_STRENGTHS-1);
    pre_analysis_inject_num = inject_num;
    inject_num = 0;
    set_xor_stipple();
    set_xor_mask();
    set_colormap_heatmap();
    redraw_control_win();
    if (pre_analysis_reverse_mode=reverse_mode) {
      reverse_everything();
      reverse_mode=0;
    }
  }
}
