/*
 * routines for converting datum items to strings and vice-versa
 *
 * Copyright 1994, 1995 Bruno Olshausen and Bill Press
 * Washington University School of Medicine
 *
 */

#include <stdio.h>
#include <math.h>
#include <string.h>

#include "xanat.h"

void datum2str(Datum *data, int index, char *rawString)
{
  char tempString[400];
  int  i, j;

  Area    *currentArea;
    
  *rawString  = '\0';
  *tempString = '\0';
  switch (index) {
   case 0:
    strcpy(rawString, data->ref.full);
    break;
   case 1:
    for ( currentArea=data->injAreas; currentArea!=NULL;
	 currentArea=currentArea->next) {
      strcat(rawString, currentArea->name);
      sprintf(tempString, " (%d%%) ",(int)rint(currentArea->fract));
      strcat(rawString, tempString);
    }
    break;
   case 2:
    for ( currentArea=data->labelAreas; currentArea!=NULL;
	 currentArea=currentArea->next) {
      strcat(rawString, currentArea->name);
      sprintf(tempString, " (%d%%) ",(int)rint(currentArea->fract));
      strcat(rawString, tempString);
    }
    break;
   case 3:
    if (data->confidence!=0)
      sprintf(rawString, "%d", data->confidence);
    break;
   case 4:
    switch (data->labelType) {
     case ANTEROGRADE:
      sprintf(rawString, "a");
      break;
     case RETROGRADE:
      sprintf(rawString, "r");
      break;
    }
    break;
   case 5:
    strcpy(rawString, data->comments);
    break;
  }
}

int str2datum(Datum *data, int index, char *rawString)
{
  int i, j;
  char words[100][20];
  int	 numbers[100];
  double totalFract;
  char zero = '0';
  int errorNum=0;
    
  Area    *currentArea;
    
  Area    *lastArea;
    
  pmes("");

  switch (index)
    {
     case 0:
      strcpy(data->ref.full, rawString);
      redraw_index_win();
      break;
     case 3:
      parseNumbers(numbers, rawString);
      data->confidence = *numbers;
      break;
     case 4:
      switch (*rawString)
	{
	 case 'a':
	  data->labelType = ANTEROGRADE;
	  break;
	 case 'r':
	  data->labelType = RETROGRADE;
	  break;
	 case '\0':
	  data->labelType = 0;
	  break;
	 default:
	  errorNum = 8;
	  perr("Label type must be a, r, or nothing");
	}
      break;
     case 5:
      strcpy(data->comments, rawString);
      break;
    }
  return(errorNum);
}

void ref2abbrev(Datum *data, char *rawString)
{
  char *ref=data->ref.abbrev;

  char tempStuff[80];
  char *tempString;
    
  int i;

  if (*rawString == '\0') {
	
    strcpy(ref, "(no ref)");

  } else {

    tempString = strcpy(tempStuff, rawString);
    strcat(tempString, " ");    
    tempString = strtok(tempString, " ");
    
    while (tempString!=NULL && *tempString != '(') {

      if (strcmp(tempString, "and")!=0)
	*ref++ = *tempString;
      tempString = strtok(NULL, " ");
    }
    
    if (tempString != NULL) {
      tempString++;
      i=0;
      while (i<4 && *tempString!=')') {
	*ref++ = *tempString++;
	i++;
      }
    }
	
    *ref = '\0';
  }
}

void find_comparison_abbrevs(char *from_where, Datum *compare_from,
			     Datum *data)
{
  if (compare_from)
    if (compare_from->type==DATA_TYPE) {
      sprintf(from_where, "d");
      sprintf(data->ref.full, "%s (%d)", compare_from->ref.abbrev,
	      compare_from->ref.num);
    }
    else
      sprintf(from_where, "%c%d", *(compare_from->ref.abbrev),
	      compare_from->ref.num);
  else
    sprintf(from_where, "X");
}

void analysis2abbrev(Datum *data)
{
  char which_1[5];
  char which_2[5];

  if (data->analysisMethod < COMPARE_OFFSET)
    strcpy(data->ref.abbrev, "Analysis");
  else {

    strcpy(data->ref.abbrev, "Compare");

    find_comparison_abbrevs(which_1, data->compareFrom1, data);
    find_comparison_abbrevs(which_2, data->compareFrom2, data);

    switch (data->analysisMethod) {
     case SUBTRACTION:
      sprintf(data->ref.comparison, "%s-%s", which_2, which_1);
      break;
     case ADDITION:
      sprintf(data->ref.comparison, "%s+%s", which_2, which_1);
      break;
     case MULTIPLICATION:
      sprintf(data->ref.comparison, "%s*%s", which_2, which_1);
      break;
    }
  }
}

renum_refs(int mode)
{
  Datum	*dptr=list[mode];
  Ref	*ref_list=NULL;
  Ref	*ref_ptr;
  int	found_ref;

  while (dptr) {
    found_ref=0;
    ref_ptr=ref_list;
    while (ref_ptr && !found_ref) {
      if (!strcmp(ref_ptr->abbrev,dptr->ref.abbrev)) {
	ref_ptr->num++;
	dptr->ref.num=ref_ptr->num+1;
	found_ref=1;
      }
      ref_ptr=ref_ptr->next;
    }
    if (!found_ref) {
      ref_ptr=(Ref *) calloc (1, sizeof(Ref));
      MCHECK(ref_ptr);
      strcpy(ref_ptr->abbrev,dptr->ref.abbrev);
      ref_ptr->next=ref_list;
      ref_list=ref_ptr;
      dptr->ref.num=1;
    }
    dptr=dptr->next[mode];
  }
  freeRefs(ref_list);
}

void search2str(searchType *search, int index, char *rawString)
{
  switch (index)
    {
     case 0:
      strcpy(rawString, search->direction);
      break;
     case 1:
      strcpy(rawString, search->area);
      break;
     case 2:
      strcpy(rawString, search->reference);
      break;
     case 3:
      strcpy(rawString, search->comments);
      break;

    }
}

void str2search(searchType *search, int index, char *rawString)
{
  switch (index)
    {
     case 0:
      strcpy(search->direction, rawString);
      break;
     case 1:
      strcpy(search->area, rawString);
      break;
     case 2:
      strcpy(search->reference, rawString);
      break;
     case 3:
      strcpy(search->comments, rawString);
      break;

    }
}
