/*
 * calibration routines for computing mouse coordinates
 *
 * Copyright 1994, 1995 Bill Press and Bruno Olshausen
 * Washington University School of Medicine
 *
 */

#include <stdio.h>
#include <math.h>
#include <malloc.h>

#include "xanat.h"
#include "coords.h"

CalibrateType	*slice;
ScaleType	*scale;
int		*validCoord;


validCoordP(int image_num)
{
  return(validCoord[image_num]);
}

StereotaxPoint pixToSt(PixPoint *original, CalibrateType *slice,
		       ScaleType *scale, int reversed)
{
  StereotaxPoint converted;

  int		   newX;
  int		   newY;
    
  newY = (int) fabs ((double) original->y - image_height_max); /*temp fix*/

  newX = (!reversed)? original->x : (int) fabs ((double) original->x -
						image_width_max); /*temp fix*/
    
  converted.x = slice->coords[0].sX +
    scale->toSt.x*(newX - slice->coords[0].pX);
  converted.y = slice->coords[0].sY +
    scale->toSt.y*(newY - slice->coords[0].pY);
   
  return(converted);
}

PixPoint stToPix(StereotaxPoint *original, CalibrateType *slice,
		 ScaleType *scale, int reversed)
{
  PixPoint converted;

  int	     oldX;
  int	     oldY;
    
  oldX	= rint(slice->coords[0].pX +
	       scale->toPix.x*(original->x - slice->coords[0].sX));
  oldY        = rint(slice->coords[0].pY +
		     scale->toPix.y*(original->y - slice->coords[0].sY));

  converted.x = (!reversed)? oldX : (int) fabs ((double) oldX -
						image_width_max); /*temp fix*/
  converted.y = (int) fabs ((double) oldY - image_height_max); /*temp fix*/
   
  return(converted);
}

void initConversionVars()
{
  slice=(CalibrateType *)calloc(num_images, sizeof(CalibrateType));
  MCHECK(slice);
  scale=(ScaleType *)calloc(num_images, sizeof(ScaleType));
  MCHECK(scale);
  validCoord=(int *)calloc(num_images, sizeof(int));
  MCHECK(validCoord);
}

void initConversion(char *filename, int i)
{
  int j;
  FILE *fp;

  if ((fp = fopen(filename, "r"))==NULL) {
	
    validCoord[i] = 0;

  } else {

    for ( j=0; j<2; j++ ) {
      fscanf(fp, "%d %d", &(slice[i].coords[j].sX), &(slice[i].coords[j].sY));
      fscanf(fp, "%d %d", &(slice[i].coords[j].pX), &(slice[i].coords[j].pY));
    }
    fclose(fp);

    scale[i].toSt.x = ((double)(slice[i].coords[1].sX-slice[i].coords[0].sX)/
		       (double)(slice[i].coords[1].pX-slice[i].coords[0].pX));
    scale[i].toSt.y = ((double)(slice[i].coords[1].sY-slice[i].coords[0].sY)/
		       (double)(slice[i].coords[1].pY-slice[i].coords[0].pY));
    scale[i].toPix.x = 1/scale[i].toSt.x;
    scale[i].toPix.y = 1/scale[i].toSt.y;
	
    validCoord[i] = 1;
  }
}

StereotaxPoint win2coord(int x, int y, int n, int reversed)
{
  PixPoint	 win_pos;
  StereotaxPoint st_pos;
  
  win_pos.x=x;
  win_pos.y=y;
  return(pixToSt(&win_pos,&slice[n],&scale[n], reversed));
}
