/* 
 * routines for performing endian machine conversions 
 *
 * Copyright 1994, 1995 Bill Press and Bruno Olshausen
 * Washington University School of Medicine
 *
 */

#include <stdio.h>
#include <fcntl.h>

#include "xanat.h"

typedef struct area_in {
  Object	*object;
  char		name[CHARS_PER_AREA_LABEL];
  struct area_in *next;
} AreaIn;

int flip_short (short *orig_short)
{
  char	*orig_char, *copy_char;
  short	copy_short = *orig_short;

  short i;

  orig_char = (char *) orig_short;
  copy_char = (char *) (&copy_short)+1;

  for (i=0; i<2; i++)
    *orig_char++ = *copy_char--;
}

int flip_int (int *orig_int)
{
  char	*orig_char, *copy_char;
  int		copy_int = *orig_int;

  int i;

  orig_char = (char *) orig_int;
  copy_char = (char *) (&copy_int)+3;

  for (i=0; i<4; i++)
    *orig_char++ = *copy_char--;
}

double flip_double (double *orig_double)
{
  char	*orig_char, *copy_char;
  double	copy_double = *orig_double;

  double i;

  orig_char = (char *) orig_double;
  copy_char = (char *) (&copy_double)+7;

  for (i=0; i<8; i++)
    *orig_char++ = *copy_char--;
}

flip_object_to_big (Object *obj, double version_num)
{
  int i;

  flip_int(&(obj->header.shape));
  flip_int(&(obj->header.type));

  if (version_num>=1.3) {
    flip_int(&(obj->header.strength));
    flip_int(&(obj->header.inj_num));
    flip_int(&(obj->header.size));
  }

  if (obj->header.shape==1) {
    flip_int(&(obj->polygon.num_points));
    for (i=0; i<obj->polygon.num_points; i++) {
      flip_short(&(obj->polygon.points[i].x));
      flip_short(&(obj->polygon.points[i].y));
    }
  } else {
    flip_short(&(obj->ellipse.upper_left.x));
    flip_short(&(obj->ellipse.upper_left.y));
    flip_short(&(obj->ellipse.size.x));
    flip_short(&(obj->ellipse.size.y));
  }
}

flip_object_to_little (Object *obj, double version_num)
{
  int i;

  if (obj->header.shape==1) {
    for (i=0; i<obj->polygon.num_points; i++) {
      flip_short(&(obj->polygon.points[i].x));
      flip_short(&(obj->polygon.points[i].y));
    }
    flip_int(&(obj->polygon.num_points));
  } else {
    flip_short(&(obj->ellipse.upper_left.x));
    flip_short(&(obj->ellipse.upper_left.y));
    flip_short(&(obj->ellipse.size.x));
    flip_short(&(obj->ellipse.size.y));
  }

  flip_int(&(obj->header.shape));
  flip_int(&(obj->header.type));

  if (version_num>=1.3) {
    flip_int(&(obj->header.strength));
    flip_int(&(obj->header.inj_num));
    flip_int(&(obj->header.size));
  }
}

flip_datum (Datum *currentDatum, int toBig)
{
  int i,j;
	
  Area	*currentArea;
  Object	*currentObject;

  flip_int(&(currentDatum->writeProtect));

  flip_int(&(currentDatum->confidence));
  flip_int(&(currentDatum->labelType));

  for (currentArea=currentDatum->injAreas; currentArea!=NULL;
       currentArea=currentArea->next)
    flip_double(&(currentArea->fract));
  for (currentArea=currentDatum->labelAreas; currentArea!=NULL;
       currentArea=currentArea->next)
    flip_double(&(currentArea->fract));

  for ( i=0; i<num_images; i++ ) {
    flip_int(&(currentDatum->validSlice[i]));
    for (currentObject=currentDatum->objects[i];
	 currentObject!=NULL;
	 currentObject = currentObject->header.next )
      if (toBig)
	flip_object_to_big (currentObject, VERSION);
      else
	flip_object_to_little (currentObject, VERSION);
  }
}	
