/*
 * deallocation of datums and associated structures
 *
 * Copyright 1994, 1995 Bruno Olshausen and Bill Press
 * Washington University School of Medicine
 *
 */


#include <stdio.h>

#include "xanat.h"
#include "io.h"

void freeObject(Object *object)
{
  Object *lastObject = object;
  Object *currentObject;
    
  if (object!=NULL) {
    for (currentObject=lastObject->header.next; currentObject!=NULL;
	 currentObject=currentObject->header.next) {
      free(lastObject);
      lastObject=currentObject;
    }
    free(lastObject);
  }
}

void freeArea(Area *area)
{
  Area *lastArea = area;
  Area *currentArea;
    
  if (area!=NULL) {
    for (currentArea=lastArea->next; currentArea!=NULL;
	 currentArea=currentArea->next) {
      free(lastArea);
      lastArea=currentArea;
    }
    free(lastArea);
  }
}

void freeDatum(Datum *datum)
{
  int i;
    
  if (datum!=NULL) {
    freeArea(datum->injAreas);
    freeArea(datum->labelAreas);
    for ( i=0; i<num_images; i++ )
      freeObject(datum->objects[i]);
    free(datum->objects);
    free(datum->validSlice);
    if (datum->type==ANALYSIS_TYPE) {
      for ( i=0; i<num_images; i++)
	free(datum->heatmap[i]);
      free(datum->heatmap);
    }
    free(datum);
  }
}

void freeRefs(Ref *refs)
{
  Ref *ref_ptr=refs;

  while (ref_ptr) {
    refs=ref_ptr->next;
    free(ref_ptr);
    ref_ptr=refs;
  }
}
