/*
 * database initialization
 *
 * Copyright 1994, 1995 Bruno Olshausen and Bill Press
 * Washington University School of Medicine
 *
 */

#include <stdio.h>
#include <fcntl.h>
#include <malloc.h>

#include "xanat.h"

#define IMAGE_LIST "image_list"
#define IMAGE_PATH "images/"
#define AREAS_PATH "areas/"
#define CAL_PATH "cal/"

init()
{
  int			i,cols,rows;
  char			line[80], image_name[80], filename[80];
  FILE			*fp;
  extern AreaDef	*read_area_defs();
  char			*toEndianTest;
  int			endianTest = 1;

  /* check variable sizes */

  if (sizeof(short)!=2 || sizeof(int)!=4 || sizeof(double)!=8)
    print_wrong_machine_message();

  /* figure out what kind of machine is being used */

  toEndianTest = (char *) &endianTest;
  bigEndian = *toEndianTest;

  /* read images */

  if ((fp=fopen(IMAGE_LIST,"r"))==NULL)
    fatal_error("couldn't open image list file");

  i=0;
  while (fgets(line,80,fp)) i++;
  num_images=i;
  fclose(fp);

  image=(Image *)calloc(num_images,sizeof(Image));
  MCHECK(image);
  icon=(Image *)calloc(num_images,sizeof(Image));
  MCHECK(icon);

  initConversionVars();

  fprintf(stderr,"Reading images");

  fp=fopen(IMAGE_LIST,"r");
  i=0;
  while (fgets(line,80,fp)) {

    fprintf(stderr,".", i+1);

    sscanf(line,"%s %d %d",image_name,&cols,&rows);

    strcpy(filename,IMAGE_PATH);
    strcat(filename,image_name);
    if (read_image(filename,&image[i],cols,rows)==0) {
      fprintf(stderr,"couldn't read image: %s\n",filename);
      exit(1);
    }

    strcat(filename,".icon");
    if (read_image(filename,&icon[i],cols/ICON_SF,rows/ICON_SF)==0) {
      fprintf(stderr,"couldn't read image: %s\n",filename);
      exit(1);
    }

    strcpy(filename,AREAS_PATH);
    strcat(filename,image_name);
    read_areas_file(filename,i);

    strcpy(filename,CAL_PATH);
    strcat(filename,image_name);
    initConversion(filename, i);

    i++;
  }
  close(fp);
  fprintf(stderr, "\n");

  image_width_max=image_height_max=0;
  for (i=0; i<num_images; i++) {
    if (image[i].width>image_width_max)
      image_width_max=image[i].width;
    if (image[i].height>image_height_max)
      image_height_max=image[i].height;
  }
  image_nrc_max=image_width_max*image_height_max;
  icon_width_max=image_width_max/ICON_SF;
  icon_height_max=image_height_max/ICON_SF;
  icon_nrc_max=icon_width_max*icon_height_max;


  /* set all injection types to visible */
    
  for (i=0; i<NUM_DIFF_INJ; i++)
    inject_toggles[i]=1;
    
  /* index */

  for (i=0; i<NUM_MODES; i++) {
    index_page[i]=0;
  }

  /* list */

  for (i=0; i<NUM_LISTS; i++)
    list[i]=selected_datum[i]=NULL;

  /* initialize analysis datum */

  list[ANALYSIS]=selected_datum[ANALYSIS]=(Datum *)calloc(1,sizeof(Datum));
  MCHECK(list[ANALYSIS]);
  init_datum(list[ANALYSIS],ANALYSIS_TYPE);
  analysis2abbrev(list[ANALYSIS]);
  renum_refs(ANALYSIS);

}

read_image(filename,iptr,cols,rows)
    char	*filename;
    Image	*iptr;
    int	cols,rows;
{
  int		fd;
  char		overlay_file[80];

  if ((fd=open(filename,O_RDONLY))==-1)
    return(0);
  iptr->width=cols;
  iptr->height=rows;
  iptr->nrc=cols*rows;
  iptr->data = (byte *)calloc(iptr->nrc,sizeof(byte));
  MCHECK(iptr->data);
  if (read(fd,iptr->data,iptr->nrc) != iptr->nrc)
    fatal_error("image didn't contain expected number of pixels");
  close(fd);

  sprintf(overlay_file,"%s.overlay",filename);
  if ((fd=open(overlay_file,O_RDONLY))!=-1) {
    iptr->overlay = (byte *)calloc(iptr->nrc,sizeof(byte));
    MCHECK(iptr->overlay);
    if (read(fd,iptr->overlay,iptr->nrc) != iptr->nrc)
      fatal_error("overlay didn't contain expected number of pixels");
    close(fd);
  }
  else {
    iptr->overlay=NULL;
  }
    
  return(1);
}


print_wrong_machine_message()
{
  fprintf(stderr, "Your machine does not have storage sizes\n");
  fprintf(stderr, "that are compatable with this database\n");
  fprintf(stderr, "(2 byte short, 4 byte int, 8 byte double).\n");
  fprintf(stderr, "Do not attempt to read in area files\n");
  fprintf(stderr, "(those in the areas directory) or data\n");
  fprintf(stderr, "files that were supplied with this\n");
  fprintf(stderr, "distribution, or that were created on\n");
  fprintf(stderr, "a machine with different specs from yours.\n");
  fprintf(stderr, "Feel free to contact us if you see this\n");
  fprintf(stderr, "message.\n");
}
