/*
 * routines for adding and removing items from various lists: datum, analysis,
 * stack, and search
 *
 * Copyright 1994, 1995 Bruno Olshausen and Bill Press
 * Washington University School of Medicine
 *
 */


#include <stdio.h>
#include <malloc.h>

#include "xanat.h"


init_datum(datum,type)
    Datum	*datum;
    int	type;
{
  int	i;

  datum->next[DATA]=NULL;
  datum->next[SEARCH]=NULL;
  datum->prev[DATA]=NULL;
  datum->prev[SEARCH]=NULL;

  datum->objects=(Object **)calloc(num_images,sizeof(Object *));
  MCHECK(datum->objects);
  datum->validSlice=(int *)calloc(num_images,sizeof(int));
  MCHECK(datum->validSlice);
  for (i=0; i<num_images; i++) {
    datum->objects[i]=NULL;
    if (type==ANALYSIS_TYPE)
      datum->validSlice[i]=1;
    else
      datum->validSlice[i]=0;
  }
  datum->writeProtect=0;

  datum->type=type;

  if (type==ANALYSIS_TYPE) {
    datum->heatmap=(double **)calloc(num_images,sizeof(double *));
    MCHECK(datum->heatmap);
    for (i=0; i<num_images; i++) {
      datum->heatmap[i]=(double *)calloc(icon[i].nrc,sizeof(double));
      MCHECK(datum->heatmap[i]);
    }
    datum->analysisMethod=analysis_type;
    if (analysis_type<COMPARE_OFFSET)
	analysis2abbrev(datum);
  }
  else
    ref2abbrev(datum,"");
}


add_to_list(datum,where,mode)
    Datum	*datum,*where;
    int		mode;
{
  Datum *next;

  next=where->next[mode];
  where->next[mode] = datum;
  datum->next[mode] = next;
  datum->prev[mode] = where;
  if (next)
    next->prev[mode] = datum;
}

add_to_list_top(datum,mode)
    Datum	*datum;
    int		mode;
{
  datum->next[mode] = list[mode];
  datum->prev[mode] = NULL;
  if (datum->next[mode])
    datum->next[mode]->prev[mode]=datum;
  list[mode] = datum;
}

add_to_list_bottom(datum,mode)
    Datum	*datum;
    int		mode;
{
  Datum *last=list[mode];

  if (last) {
    while (last->next[mode])
      last=last->next[mode];
    last->next[mode]=datum;
    datum->prev[mode]=last;
    datum->next[mode]=NULL;
  }
  else {
    list[mode]=datum;
    datum->prev[mode]=NULL;
    datum->next[mode]=NULL;
  }
}

Datum *remove_from_list(datum,mode)
    Datum	*datum;
    int		mode;
{
  Datum *return_ptr, *next_stack_datum;

  if (mode!=STACK) {
    next_stack_datum = remove_from_list(datum,STACK);
    if (selected_datum[STACK]==datum)
      selected_datum[STACK]=next_stack_datum;
  }

  if (!datum->prev[mode]) {
    return_ptr=list[mode]=datum->next[mode];
    if (return_ptr)
      return_ptr->prev[mode] = NULL;
  }
  else {
    return_ptr=datum->prev[mode];
    return_ptr->next[mode]=datum->next[mode];
    if (return_ptr->next[mode])
      return_ptr->next[mode]->prev[mode]=return_ptr;
  }
  if (mode==STACK) {
    datum->next[mode]=NULL;
    datum->prev[mode]=NULL;
  }
  else
    freeDatum(datum);
  return(return_ptr);
}

/*
 * Compare list
 */

redo_compare_refs(Datum *deleted_datum)
{
  Datum *dptr=list[COMPARE];

  while (dptr) {
    if (dptr->compareFrom1==deleted_datum)
      dptr->compareFrom1=NULL;
    if (dptr->compareFrom2==deleted_datum)
      dptr->compareFrom2=NULL;
    analysis2abbrev(dptr);
    dptr=dptr->next[COMPARE];
  }
}

/*
 * stack list
 */

moveToStackTop(Datum *moveThis)
{
  Datum *return_ptr;

  if (moveThis->prev[STACK]) {
    moveThis->prev[STACK]->next[STACK] = moveThis->next[STACK];
    if (moveThis->next[STACK])
      moveThis->next[STACK]->prev[STACK] = moveThis->prev[STACK];
    moveThis->prev[STACK] = NULL;
    moveThis->next[STACK] = list[STACK];
    list[STACK]->prev[STACK] = moveThis;
  }
  list[STACK] = moveThis;
}

int stack_check (Datum *addThis)
{
  Datum *stack_datum = list[STACK];

  while (stack_datum) {
    if (addThis==stack_datum)
      return (0);
    stack_datum = stack_datum->next[STACK];
  }
  return (1);
}
