/* 
 * routines for performing record searches
 *
 * Copyright 1994, 1995 Bill Press and Bruno Olshausen
 * Washington University School of Medicine
 *
 */

#include <stdio.h>

#include "xanat.h"

void do_list_analysis(keyWords)
    searchType	*keyWords;
{
  Datum   *datum;
  int		direction;

  int result;
  
  extern Datum	*searchList();
  extern char	*query();

  list[SEARCH]=selected_datum[SEARCH]=searchList(list[DATA],search_fields);

  if (selected_datum[view_mode]) {
    if (selected_datum[view_mode]->type==ANALYSIS_TYPE)
      datum=selected_datum[view_mode];
    else
      datum=selected_datum[ANALYSIS];
  } else
    datum=selected_datum[ANALYSIS];
  
  if (datum) {

    switch (keyWords->direction[0]) {
     case 't':
      direction = 0;
      break;
     case 'f':
      direction = 1;
      break;
     default:
      direction = 2;
      break;
    }

    get_refs_from_search_list(datum->ref.full);

    search_list2objects(keyWords->area, datum->objects);
    compute_areas(datum);
    
    datum->analysis_midpoint=0;
    if (analysis_type==SUPERPOSITION)
      result = analyzeByListSuperpos(datum, list[SEARCH], direction);
    else if (analysis_type==BAYES)
      result = analyzeByListBayes(datum, list[SEARCH], direction);
    else {
      perr("Selected analysis method");
      return;
    }
    if (result==-1)
      return;
    datum->analysisMethod=analysis_type;
    analysis2abbrev(datum);
    set_view_mode(ANALYSIS);
    perr("Finished analysis");
  }
}

data_search()
{
  extern Datum	*searchList();

  list[SEARCH]=selected_datum[SEARCH]=searchList(list[DATA],search_fields);
  set_view_mode(SEARCH);
  perr("Search completed");
}


get_refs_from_search_list(string)
    char	*string;
{
  Datum	*dptr=list[SEARCH];
  Ref	*ref_list=NULL;
  Ref	*ref_ptr, *end_ptr;
  int	found_ref;

  while (dptr) {
    found_ref=0;
    ref_ptr=ref_list;
    while (ref_ptr && !found_ref) {
      if (!strcmp(ref_ptr->abbrev,dptr->ref.abbrev))
	found_ref=1;
      ref_ptr=ref_ptr->next;
    }
    if (!found_ref) {
      ref_ptr=(Ref *) calloc (1, sizeof(Ref));
      MCHECK(ref_ptr);
      strcpy(ref_ptr->abbrev,dptr->ref.abbrev);
      if (end_ptr=ref_list) {
	while (end_ptr->next)
	  end_ptr=end_ptr->next;
	end_ptr->next=ref_ptr;
      }
      else
	ref_list=ref_ptr;
      ref_ptr->next=NULL;
    }
    dptr=dptr->next[SEARCH];
  }

  ref_ptr=ref_list;
  string[0]='\0';
  
  while (ref_ptr) {
    if (strlen(string)+strlen(ref_ptr->abbrev)+1<CHARS_PER_REF) {
      strcat(string, ref_ptr->abbrev);
      strcat(string, " ");
      ref_ptr=ref_ptr->next;
    }
    else {
      strcat(string, "+");
      break;
    }
  }
  freeRefs(ref_list);
}


void scoot(char *s)
{
  int i;
    
  for ( i=0; s[i]!='\0'; i++ )
    s[i] = s[i+1];
}

Datum *searchList(Datum *data, searchType keyWords)
{
  int i, j;
  int foundFirst;
  int inList;

  Datum *currentDatum;
  Area  *currentArea;
  Datum *startDatum = data;
  Datum *lastDatum;
          
  Datum *orDatum;
  Area  *orArea;
  Datum *orStart = NULL;

  Datum *init = data;
    
  Datum *searchDatum;
    
  char searchString[100][20];
  char targetString[100][20];
  int  direction;

  int	datumUsed;
  int	justAdded;
  int	notEmpty = 0;
    
  if (strlen(keyWords.direction) == 0 && strlen(keyWords.area) == 0 &&
      strlen(keyWords.reference) == 0 && strlen(keyWords.comments) == 0)
    return(NULL);

  while (init!=NULL) {
    init->prev[SEARCH] = init->prev[DATA];
    init->next[SEARCH] = init->next[DATA];
    init->next[OR] = NULL;
    init = init->next[DATA];
  }

  for (currentDatum = startDatum; currentDatum!=NULL;
       currentDatum=currentDatum->next[DATA])
    currentDatum->areaWeight = 0;
    
  switch (*keyWords.direction) {
   case 't':
    direction = TO;
    break;
   case 'f':
    direction = FROM;
    break;
   default:
    direction = EITHER;
    break;
  }

  /* Search on cortical areas */

  parseString(searchString, keyWords.area);
  for ( i=0; *searchString[i]!='\0'; i++ )
    if (searchString[i][0]!='+') {
      for ( currentDatum = startDatum, foundFirst = 0;
	   currentDatum != NULL && foundFirst==0;
	   currentDatum = currentDatum->next[SEARCH] ) {
	if (direction==EITHER || !currentDatum->labelType ||
	    (direction==TO && currentDatum->labelType==RETROGRADE) ||
	    (direction==FROM &&  currentDatum->labelType==ANTEROGRADE))
	  for (currentArea=currentDatum->injAreas; currentArea!=NULL;
	       currentArea=currentArea->next )	    
	    if (strcmp(searchString[i], currentArea->name)==0) {
	      startDatum = currentDatum;
	      currentDatum->areaWeight += currentArea->fract;
	      foundFirst = 1;
	    }
	if (direction==EITHER || !currentDatum->labelType ||
	    (direction==TO && currentDatum->labelType==ANTEROGRADE) ||
	    (direction==FROM &&  currentDatum->labelType==RETROGRADE))
	  for (currentArea=currentDatum->labelAreas; currentArea!=NULL;
	       currentArea=currentArea->next )	    
	    if (strcmp(searchString[i], currentArea->name)==0) {
	      startDatum = currentDatum;
	      currentDatum->areaWeight += currentArea->fract;
	      foundFirst = 1;
	    }
      }
      if (foundFirst==1) {	
	for ( currentDatum = startDatum->next[SEARCH], lastDatum = startDatum;
	     currentDatum != NULL;
	     currentDatum = currentDatum->next[SEARCH] ) {
	  if (direction==EITHER || !currentDatum->labelType ||
	      (direction==TO && currentDatum->labelType==RETROGRADE) ||
	      (direction==FROM &&  currentDatum->labelType==ANTEROGRADE))
	    for (currentArea=currentDatum->injAreas, datumUsed=0; 
		 currentArea!=NULL; currentArea=currentArea->next )	    
	      if (strcmp(searchString[i], currentArea->name)==0) {
		lastDatum->next[SEARCH] = currentDatum;
		currentDatum->prev[SEARCH] = lastDatum;
		lastDatum = currentDatum;
		currentDatum->areaWeight += currentArea->fract;
		datumUsed = 1;
	      }
	  if (direction==EITHER || !currentDatum->labelType ||
	      (direction==TO && currentDatum->labelType==ANTEROGRADE) ||
	      (direction==FROM &&  currentDatum->labelType==RETROGRADE))
	    for (currentArea=currentDatum->labelAreas; currentArea!=NULL;
		 currentArea=currentArea->next )	    
	      if (strcmp(searchString[i], currentArea->name)==0) {
		currentDatum->areaWeight += currentArea->fract;
		if (!datumUsed) {
		  lastDatum->next[SEARCH] = currentDatum;
		  currentDatum->prev[SEARCH] = lastDatum;
		  lastDatum = currentDatum;
		}
	      }

	}
	lastDatum->next[SEARCH] = NULL;
      } else
	return(NULL);
    } else {
      scoot(searchString[i]);
      for ( orDatum=data; orDatum!=NULL; orDatum=orDatum->next[DATA] ) {
	if (direction==EITHER || !currentDatum->labelType ||
	    (direction==TO && currentDatum->labelType==RETROGRADE) ||
	    (direction==FROM &&  currentDatum->labelType==ANTEROGRADE))
	  for ( orArea=orDatum->injAreas, justAdded=0;
	       orArea!=NULL; orArea=orArea->next )
	    if (strcmp(searchString[i], orArea->name)==0) {
	      for ( searchDatum=orStart, inList=0;
		   searchDatum!=NULL && inList==0;
		   searchDatum=searchDatum->next[OR] )
		if (searchDatum == orDatum)
		  inList = 1;
	      if (inList==0) {
		orDatum->areaWeight += orArea->fract;
		justAdded = 1;
		if (orStart==NULL) {
		  orStart = orDatum;
		} else {
		  orDatum->next[OR] = orStart->next[OR];
		  orStart->next[OR] = orDatum;
		}
	      }
	    }
	if (direction==EITHER || !currentDatum->labelType ||
	    (direction==TO && currentDatum->labelType==ANTEROGRADE) ||
	    (direction==FROM &&  currentDatum->labelType==RETROGRADE))
	  for ( orArea=orDatum->labelAreas; orArea!=NULL; orArea=orArea->next )
	    if (strcmp(searchString[i], orArea->name)==0) {
	      for ( searchDatum=orStart, inList=0;
		   searchDatum!=NULL && inList==0;
		   searchDatum=searchDatum->next[OR] )
		if (searchDatum == orDatum)
		  inList = 1;
	      if (inList==0) {
		if (justAdded)
		  orDatum->areaWeight += orArea->fract;
		if (orStart==NULL) {
		  orStart = orDatum;
		} else {
		  orDatum->next[OR] = orStart->next[OR];
		  orStart->next[OR] = orDatum;
		}
	      }
	    }
      }
    }

  /* Search on references */

  parseString(searchString, keyWords.reference);
  for ( i=0; *searchString[i]!='\0'; i++ )
    if (searchString[i][0]!='+') {
      for ( currentDatum = startDatum, foundFirst = 0;
	   currentDatum != NULL && foundFirst==0;
	   currentDatum = currentDatum->next[SEARCH] ) {
	parseString(targetString, currentDatum->ref.full);
	for ( j=0; *targetString[j]!='\0'; j++ )	    
	  if (strcmp(searchString[i], targetString[j])==0) {
	    startDatum = currentDatum;
	    foundFirst = 1;
	  }
      }
      if (foundFirst==1) {	    
	for ( currentDatum = startDatum->next[SEARCH], lastDatum = startDatum;
	     currentDatum != NULL;
	     currentDatum = currentDatum->next[SEARCH] ) {
	  parseString(targetString, currentDatum->ref.full);
	  for ( j=0; *targetString[j]!='\0'; j++ )
	    if (strcmp(searchString[i], targetString[j])==0) {
	      lastDatum->next[SEARCH] = currentDatum;
	      currentDatum->prev[SEARCH] = lastDatum;
	      lastDatum = currentDatum;
	    }
	}
	lastDatum->next[SEARCH] = NULL;
      } else
	return(NULL);
    } else {
      scoot(searchString[i]);
      for ( orDatum=data; orDatum!=NULL; orDatum=orDatum->next[DATA] ) {
	parseString(targetString, orDatum->ref.full);
	for ( j=0; *targetString[j]!='\0'; j++ )
	  if (strcmp(searchString[i], targetString[j])==0) {
	    for ( searchDatum=orStart, inList=0; 
		 searchDatum!=NULL && inList==0;
		 searchDatum=searchDatum->next[OR] )
	      if (searchDatum == orDatum)
		inList = 1;
	    if (inList==0)
	      if (orStart==NULL) {
		orStart = orDatum;
	      } else {
		orDatum->next[OR] = orStart->next[OR];
		orStart->next[OR] = orDatum;
	      }
	  }
      }
    }

  /* Search on comments */

  parseString(searchString, keyWords.comments);
  for ( i=0; *searchString[i]!='\0'; i++ )
    if (searchString[i][0]!='+') {
      for ( currentDatum = startDatum, foundFirst = 0;
	   currentDatum != NULL && foundFirst==0;
	   currentDatum = currentDatum->next[SEARCH] ) {
	parseString(targetString, currentDatum->comments);
	for ( j=0; *targetString[j]!='\0'; j++ )	    
	  if (strcmp(searchString[i], targetString[j])==0) {
	    startDatum = currentDatum;
	    foundFirst = 1;
	  }
      }
      if (foundFirst==1) {	    
	for ( currentDatum = startDatum->next[SEARCH], lastDatum = startDatum;
	     currentDatum != NULL;
	     currentDatum = currentDatum->next[SEARCH] ) {
	  parseString(targetString, currentDatum->comments);
	  for ( j=0; *targetString[j]!='\0'; j++ )
	    if (strcmp(searchString[i], targetString[j])==0) {
	      lastDatum->next[SEARCH] = currentDatum;
	      currentDatum->prev[SEARCH] = lastDatum;
	      lastDatum = currentDatum;
	    }
	}
	lastDatum->next[SEARCH] = NULL;
      } else
	return(NULL);
    } else {
      scoot(searchString[i]);
      for ( orDatum=data; orDatum!=NULL; orDatum=orDatum->next[DATA] ) {
	parseString(targetString, orDatum->comments);
	for ( j=0; *targetString[j]!='\0'; j++ )
	  if (strcmp(searchString[i], targetString[j])==0) {
	    for ( searchDatum=orStart, inList=0; 
		 searchDatum!=NULL && inList==0;
		 searchDatum=searchDatum->next[OR] )
	      if (searchDatum == orDatum)
		inList = 1;
	    if (inList==0)
	      if (orStart==NULL) {
		orStart = orDatum;
	      } else {
		orDatum->next[OR] = orStart->next[OR];
		orStart->next[OR] = orDatum;
	      }
	  }
      }	    
    }

  /* Combine "or" list into "and" list */
   
  for (orDatum = orStart; orDatum!=NULL; orDatum=orDatum->next[OR]) {
    for ( currentDatum = lastDatum = startDatum, inList = 0;
	 currentDatum!=NULL && inList==0;
	 currentDatum=currentDatum->next[SEARCH]) {
      if (currentDatum==orDatum)
	inList=1;
      lastDatum = currentDatum;
    }
    if (inList==0)
      if (lastDatum!=NULL) {
	lastDatum->next[SEARCH] = orDatum;
	orDatum->next[SEARCH] = NULL;
	orDatum->prev[SEARCH] = lastDatum;
      } else {
	startDatum = orDatum;
	orDatum->next[SEARCH] = NULL;
	orDatum->prev[SEARCH] = NULL;
      }
  }

  startDatum->prev[SEARCH] = NULL;
  return(startDatum);
}
