#include <X11/Xlib.h>
#include <X11/Xutil.h>

/*
 * heatmap parameters - these may be changed.  Each must be 2^x, and
 * NUM_COLORS*NUM_GREY_LEVELS_PER_COLOR must equal either 128 or 256
 */

#define NUM_COLORS 8
#define NUM_GREY_LEVELS_PER_COLOR 16

/* additional ui constants */

#define INJ_LABEL_SIZE 2*NUM_DIFF_INJ

#define NUM_GREY_LEVELS 64
#define GREYS_OFFSET (2*NUM_GREY_LEVELS)
#define HEATMAP_OFFSET (256-NUM_COLORS*NUM_GREY_LEVELS_PER_COLOR)

#define BLACK 0
#define GREY (2*NUM_GREY_LEVELS/3)
#define WHITE (NUM_GREY_LEVELS-1)
#define BLUE (GREYS_OFFSET+INJ_LABEL_SIZE)
#define DARK_BLUE (GREYS_OFFSET+INJ_LABEL_SIZE+1)
#define RED 255
#define SEARCH_COLOR (NUM_COLORS/2+1)
#define SEARCH_INDEX (HEATMAP_OFFSET+SEARCH_COLOR*NUM_GREY_LEVELS_PER_COLOR-1)

#define TILE_BIT_DIM 8

#define MAX_SCREEN_WIDTH 1200
#define ICON_BUFF 2
#define TEXT_WIN_WIDTH 325

#define FLOAT_TO_INT(x) (int)(100*x)
#define INT_TO_FLOAT(x) ((double)x/100.0)

#define QUIT_ID 0
#define LIST_ID 1
#define ANALYSIS_METHOD_ID 2
#define IMAGE_MODE_ID 3
#define VIEW_MODE_ID 4
#define DRAW_MODE_ID 5
#define ANALYSIS_ID 6
#define FILE_ID 7
#define INJ_OR_LABEL_ID 8
#define STACK_ID 9
#define WEIGHT_ID 10
#define INJ_TYPE_ID 11
#define COMPARE_ID 12
#define NUM_CONTROLS 10

#define SEARCH_BUTTON_HEIGHT 20
#define SEARCH_BUTTON_WIDTH 70

#define INDEX_ICON_HEIGHT 20
#define INDEX_OFFSET_X 14
#define INDEX_OFFSET_Y 40
#define INDEX_BOX_HEIGHT 2*INDEX_OFFSET_X


typedef struct {
  Window	window;
  GC		gc;
  int		width;
  int		height;
} win_obj;

typedef struct {
  int		height;
  int		width;
  XFontStruct 	*info;
} font_obj;

typedef struct {
  char  	*label;
  int   	id;
  int		num_sub_choices;
  char		*sub_label[6];
} control_struct;

typedef struct {
  int	x,y;
} Coord;

extern int     		screen;
extern Display 		*display;
extern Visual		*visual;
extern Colormap		cmap;

extern XGCValues	gc_values;
extern GC		image_xor_stip_gc, image_xor_dash_gc, image_handle_gc;
extern GC		image_stip_gc, image_dash_gc, icons_stip_gc;
extern GC		pixmap_gc;
extern unsigned char	*dashes[NUM_STRENGTHS];

extern XImage		*search_ximage,*data_ximage;
extern XImage		*colorstrip_ximage;

extern Pixmap		analyze_pixmap;
extern Pixmap		icons_stipple_pixmap[NUM_STRENGTHS];
extern Pixmap		image_stipple_pixmap[NUM_STRENGTHS];

extern XEvent		event;
extern Cursor		cross_cursor,arrow_cursor;
extern XColor		cursor_color[3], cursor_white, cursor_black;

extern font_obj		small_font,medium_font,large_font;

extern win_obj		control_win, icons_win, image_win, data_win,
			search_win, message_win, index_win, coord_win;

extern int		num_icons_per_row,num_icon_rows;
extern int		num_control_rows,num_controls_per_row;
extern Coord		*icon_pos, control_spacing;

extern int		colorstrip_width,colorstrip_height;

extern Box		search_box, analyze_box;
extern Box		index_stepup_box, index_pageup_box;
extern Box		index_stepdown_box, index_pagedown_box;

extern XPoint		valid_triangle[3];
extern Region		valid_region;

extern control_struct   control_list[2][2][NUM_CONTROLS];
