/* 
 * routines for manipulating coordinates
 *
 * Copyright 1994, 1995 Bruno Olshausen and Bill Press
 * Washington University School of Medicine
 *
 */

#include <stdio.h>
#include "xanat.h"
#include "ui.h"
#include "ui_objects.h"


reverse(x)
    int	x;
{
  return(image[current_image].width - x);
}

icon_reverse(x, image_num)
    int	x, image_num;
{
  return(icon[image_num].width - x);
}

copy_pos(pos1,pos2)
    XPoint	*pos1,*pos2;
{
  pos1->x=pos2->x;
  pos1->y=pos2->y;
}

set_pos(pos,x,y)
    XPoint	*pos;
    int	x,y;
{
  pos->x=x;
  pos->y=y;
}

inc_pos(pos,delta)
    XPoint	*pos,*delta;
{
  pos->x+=delta->x;
  pos->y+=delta->y;
}

dec_pos(pos,delta)
    XPoint	*pos,*delta;
{
  pos->x-=delta->x;
  pos->y-=delta->y;
}

scale_pos(pos1,pos2,sf)
    XPoint	*pos1,*pos2;
    int		sf;
{
  pos1->x=pos2->x/sf;
  pos1->y=pos2->y/sf;
}

diff_pos(delta,pos,x,y)
    XPoint	*delta,*pos;
    int		x,y;
{
  delta->x=x-pos->x;
  delta->y=y-pos->y;
}

in_region_p(org,size,x,y)
    XPoint	*org,*size;
    int		x,y;
{
  register int	diffx,diffy;

  diffx=x-org->x;
  diffy=y-org->y;
  if ((diffx>=0) && (diffx<=size->x) && (diffy>=0) && (diffy<=size->y))
    return(1);
  else
    return(0);
}
