/*
 * user-interface initialization
 *
 * Copyright 1994, 1995 Bill Press and Bruno Olshausen
 * Washington University School of Medicine
 *
 */

#include <stdio.h>
#include <math.h>
#include <malloc.h>

#include <X11/cursorfont.h>

#include "xanat.h"
#include "ui.h"

int     	screen;
Display		*display;
Visual		*visual;
Colormap	cmap;

XGCValues	gc_values;
GC		image_xor_stip_gc, image_xor_dash_gc, image_handle_gc;
GC		image_stip_gc, image_dash_gc, icons_stip_gc;
GC		pixmap_gc;
unsigned char	*dashes[NUM_STRENGTHS];

XImage		*search_ximage, *data_ximage;
XImage 		*colorstrip_ximage;

Pixmap		analyze_pixmap;
Pixmap		icons_stipple_pixmap[NUM_STRENGTHS];
Pixmap		image_stipple_pixmap[NUM_STRENGTHS];

XEvent		event;
Cursor		cross_cursor,arrow_cursor;
XColor		cursor_color[3], cursor_white, cursor_black;

font_obj	small_font,medium_font,large_font;

win_obj		icons_win, image_win, control_win, data_win,
		search_win, message_win, index_win, coord_win;

int		num_icons_per_row,num_icon_rows;
int		num_control_rows,num_controls_per_row;
Coord		*icon_pos, control_spacing;

int		colorstrip_width,colorstrip_height;

Box		search_box, analyze_box;
Box		index_stepup_box, index_stepdown_box;
Box		index_pageup_box, index_pagedown_box;

XPoint		valid_triangle[3];
Region		valid_region;

control_struct	control_list[2][2][NUM_CONTROLS]={

{{{"Quit",QUIT_ID,0,NULL},
   {"List",LIST_ID,2,{"add","delete"}},
   {"Image mode",IMAGE_MODE_ID,2,{"image","overlay"}},
   {"Draw mode",DRAW_MODE_ID,6,{"sel","ell","ply","area","fill","rev"}},
   {"Injection/Label",INJ_OR_LABEL_ID,2,{"injection","label"}},

   {"File",FILE_ID,2,{"load","save"}},
   {"Stack",STACK_ID,2,{"push","remove"}},
   {"View mode",VIEW_MODE_ID,4,{"data","search","stack","analysis"}},
   {"Injection type",INJ_TYPE_ID,NUM_DIFF_INJ,NULL},
   {"Inj/Label weight",WEIGHT_ID,NUM_STRENGTHS,NULL}},

{{"Quit",QUIT_ID,0,NULL},
   {"List",LIST_ID,2,{"add","delete"}},
   {"Image mode",IMAGE_MODE_ID,2,{"image","overlay"}},
   {"Draw mode",DRAW_MODE_ID,6,{"sel","ell","ply","area","fill","rev"}},
   {"Analysis method",ANALYSIS_METHOD_ID,2,{"superposition","bayes"}},

   {"File",FILE_ID,2,{"load","save"}},
   {"Stack",STACK_ID,2,{"push","remove"}},
   {"View mode",VIEW_MODE_ID,4,{"data","search","stack","analysis"}},
   {"Injection type",INJ_TYPE_ID,NUM_DIFF_INJ,NULL},
   {"Analysis",ANALYSIS_ID,3,{"to","from","either"}}}},

{{{"Quit",QUIT_ID,0,NULL},
   {"Comparison",COMPARE_ID,3,{"sub","add","mult"}},
   {"Image mode",IMAGE_MODE_ID,2,{"image","overlay"}},
   {"Draw mode",DRAW_MODE_ID,6,{"sel","ell","ply","area","fill","rev"}},
   {"Injection/Label",INJ_OR_LABEL_ID,2,{"injection","label"}},

   {"File",FILE_ID,2,{"load","save"}},
   {"Stack",STACK_ID,2,{"move","remove"}},
   {"View mode",VIEW_MODE_ID,4,{"data","search","stack","analysis"}},
   {"Injection type",INJ_TYPE_ID,NUM_DIFF_INJ,NULL},
   {"Inj/Label weight",WEIGHT_ID,NUM_STRENGTHS,NULL}},

{{"Quit",QUIT_ID,0,NULL},
   {"Comparison",COMPARE_ID,3,{"sub","add","mult"}},
   {"Image mode",IMAGE_MODE_ID,2,{"image","overlay"}},
   {"Draw mode",DRAW_MODE_ID,6,{"sel","ell","ply","area","fill","rev"}},
   {"Analysis method",ANALYSIS_METHOD_ID,2,{"superposition","bayes"}},

   {"File",FILE_ID,2,{"load","save"}},
   {"Stack",STACK_ID,2,{"move","remove"}},
   {"View mode",VIEW_MODE_ID,4,{"data","search","stack","analysis"}},
   {"Injection type",INJ_TYPE_ID,NUM_DIFF_INJ,NULL},
   {"Analysis",ANALYSIS_ID,3,{"to","from","either"}}}}
};

static char	tile_bits[NUM_STRENGTHS][TILE_BIT_DIM] = {
    {0x88, 0x22, 0x44, 0x11, 0x88, 0x22, 0x44, 0x11},
    {0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55},
    {0xee, 0xbb, 0x77, 0xdd, 0xee, 0xbb, 0x77, 0xdd},
    {0xef, 0xfe, 0xbf, 0xfb, 0xdf, 0xfd, 0x7f, 0xf7},
    {0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff}
  };

/*
 * open display connection
 */
setup_display()
{
  if ((display = XOpenDisplay(NULL)) == NULL) {
    fprintf(stderr,"Can't open display %s\n",XDisplayName(NULL));
    exit(1);
  }
  screen = DefaultScreen(display);
}


convert_template_to_data(int strength, char *to_data, int width, int height)
{
  int i,j;
  int byte_width = (int) ceil((double)width/TILE_BIT_DIM);

  for (i=0; i<height; i++)
    for (j=0; j<byte_width; j++)
      to_data[i*byte_width+j] = tile_bits[strength][i%TILE_BIT_DIM];
}


/* 
 * create windows, graphics contexts, etc.
 */
init_ui()
{
  Window		rootwin;
  XVisualInfo		visual_info;
  int			depth;
  unsigned int		background,border_color;
  int			xpos,ypos,border_width;
  int			app_width,app_height;
  XSizeHints		hints;
  byte			*xdata;
  int			i,j;
  char			title_name[80];

  int			divs;
  extern Colormap	init_colormap();

  char			*icons_stipple_data, *image_stipple_data;


  sprintf(title_name, "Xanat %1.1f", VERSION);

  /* window sizes, etc. */

  num_icons_per_row= (MAX_SCREEN_WIDTH -(4+TEXT_WIN_WIDTH+4))/icon_width_max;
  num_icon_rows= (num_images-1)/num_icons_per_row + 1;
  icons_win.width=num_icons_per_row*(icon_width_max+ICON_BUFF) - ICON_BUFF;
  icons_win.height=(icon_height_max+ICON_BUFF)*num_icon_rows -ICON_BUFF;

  icon_pos=(Coord *)calloc(num_images,sizeof(Coord));
  MCHECK(icon_pos);
  for (i=0; i<num_images; i++) {
    icon_pos[i].x= (i%num_icons_per_row)*(icon_width_max+ICON_BUFF)
      + (icon_width_max-icon[i].width)/2;
    icon_pos[i].y=(i/num_icons_per_row)*(icon_height_max+ICON_BUFF)
      + (icon_height_max-icon[i].height)/2;
  }

  colorstrip_width=image_width_max;
  colorstrip_height=10;

  image_win.width=image_width_max;
  image_win.height=image_height_max+colorstrip_height;

  control_win.height=100;
  control_win.width=icons_win.width+4;
  num_control_rows=2;
  num_controls_per_row=(NUM_CONTROLS+1)/2;
  control_spacing.x=control_win.width/num_controls_per_row;
  control_spacing.y=control_win.height/2;       

  message_win.width=TEXT_WIN_WIDTH;
  message_win.height=50;

  search_win.width=TEXT_WIN_WIDTH;
  search_win.height=300;

  app_width=icons_win.width+4+search_win.width+4;
  app_height=control_win.height+4+icons_win.height+4+image_win.height+4;

  data_win.width=TEXT_WIN_WIDTH;
  data_win.height=app_height-(search_win.height+4+message_win.height+4)-4;

  index_win.width=icons_win.width-(image_win.width+4);
  index_win.height=INDEX_OFFSET_Y+INDEX_ICON_HEIGHT*num_datums_per_index_page;

  coord_win.width=index_win.width;
  coord_win.height=image_win.height-(index_win.height+4);


  /* search buttons */
  search_box.lr.x=search_win.width-10;
  search_box.ul.x=search_box.lr.x-SEARCH_BUTTON_WIDTH;
  search_box.ul.y=10;
  search_box.lr.y=search_box.ul.y+SEARCH_BUTTON_HEIGHT;

  analyze_box.lr.x=search_win.width-10;
  analyze_box.ul.x=analyze_box.lr.x-SEARCH_BUTTON_WIDTH;
  analyze_box.ul.y=search_box.lr.y+10;
  analyze_box.lr.y=analyze_box.ul.y+SEARCH_BUTTON_HEIGHT;


  /* index arrows */
  index_stepup_box.ul.x=index_stepdown_box.ul.x=
    index_pageup_box.ul.x=index_pagedown_box.ul.x=0;
  index_stepup_box.lr.x=index_stepdown_box.lr.x=
    index_pageup_box.lr.x=index_pagedown_box.lr.x=INDEX_OFFSET_X;
  index_stepup_box.lr.y= (index_pageup_box.lr.y=index_stepup_box.ul.y=
			  (index_pageup_box.ul.y=INDEX_OFFSET_Y)
			  +INDEX_BOX_HEIGHT) + INDEX_BOX_HEIGHT;
  index_stepdown_box.ul.y= (index_pagedown_box.ul.y=index_stepdown_box.lr.y =
			    (index_pagedown_box.lr.y=index_win.height)
			    -INDEX_BOX_HEIGHT) - INDEX_BOX_HEIGHT;

  /* toggle slice validity box */
  valid_triangle[0].x=valid_triangle[0].y=valid_triangle[1].y=0;
  valid_triangle[1].x=0.125*image_width_max;
  valid_triangle[2].x=0;
  valid_triangle[2].y=0.125*image_width_max;
  valid_region=XPolygonRegion(valid_triangle,3,WindingRule);

  /* font and cursor */

  if ((medium_font.info=XLoadQueryFont(display,"-adobe-courier-medium-r-normal--12-120-75-75-m-70-iso8859-1"))==0) {
    fprintf(stderr,"couldn't load adobe-courier font\n");
    if ((medium_font.info=XLoadQueryFont(display,"8x13"))==0) {
      fprintf(stderr,"couldn't load 8x13 font - can't go on\n");
      exit(1);
    }
  }
  medium_font.height=medium_font.info->ascent+medium_font.info->descent;
  medium_font.width=XTextWidth(medium_font.info," ",1);

  if ((small_font.info=XLoadQueryFont(display,"-adobe-times-medium-r-normal--12-120-75-75-p-*-iso8859-1"))==0) {
    fprintf(stderr, "Couldn't load adobe-times font\n");
    if ((small_font.info=XLoadQueryFont(display,"6x9"))==0) {
      fprintf(stderr,"couldn't load 6x9 font, using 8x13 instead\n");
      small_font.info=medium_font.info;
    }
  }
  small_font.height=small_font.info->ascent+small_font.info->descent;
  small_font.width=XTextWidth(small_font.info," ",1);

  if ((large_font.info=XLoadQueryFont(display,"-adobe-times-bold-r-normal--14-140-75-75-p-*-iso8859-1"))==0) {
    fprintf(stderr,"couldn't load adobe-times font, using 8x13 instead\n");
    large_font.info=medium_font.info;
  }
  large_font.height=large_font.info->ascent+large_font.info->descent;
  large_font.width=XTextWidth(large_font.info," ",1);

  cross_cursor=XCreateFontCursor(display,XC_crosshair);
  arrow_cursor=XCreateFontCursor(display,XC_left_ptr);

  /* root window */

  depth=8;
  if (!XMatchVisualInfo(display, screen, depth, PseudoColor, &visual_info))
    if (!XMatchVisualInfo(display, screen, depth, DirectColor, &visual_info))
      fatal_error("application requires either PseudoColor or DirectColor");

  visual=visual_info.visual;
  border_width=4;
  border_color= 0;
    
  xpos=50; ypos=25;
  background=0;
  rootwin = XCreateSimpleWindow(display,XRootWindow(display,screen),
				xpos,ypos,app_width,app_height,
				border_width, border_color, background);
  XStoreName(display,rootwin,title_name);
  hints.flags = PPosition | PSize | USSize | USPosition ;
  XSetWMNormalHints(display,rootwin,&hints);
  XMapWindow(display,rootwin);
    
  /* colors */
    
  set_inj_label_colors();
  cmap=XCreateColormap(display,rootwin,visual,AllocAll);
  XSetWindowColormap(display,rootwin,cmap);
  set_colormap_heatmap();
  set_colormap_data();
  set_colormap_object_color(INJECTION);
  set_cursor_colors();
    
  /* other windows */
    
  border_width=2;
    
  background = NUM_GREY_LEVELS-1;
  control_win.window =
    XCreateSimpleWindow(display,rootwin, 0,0,
			control_win.width,control_win.height,
			border_width,border_color,background);
  gc_values.foreground=0;
  gc_values.background=background;
  gc_values.font=medium_font.info->fid;
  control_win.gc=XCreateGC(display,control_win.window,
			   GCForeground|GCBackground|GCFont, &gc_values);
  XSelectInput(display, control_win.window, ButtonPressMask|ExposureMask);
  XMapWindow(display,control_win.window);
    
  message_win.window =
    XCreateSimpleWindow(display,rootwin,
			icons_win.width+2*border_width,0,
			message_win.width,message_win.height,
			border_width,border_color,background);
  XSelectInput(display, message_win.window, KeyPressMask|ExposureMask);
  message_win.gc=XCreateGC(display,message_win.window,
			   GCForeground|GCBackground|GCFont, &gc_values);
  XMapWindow(display,message_win.window);
    
  search_win.window =
    XCreateSimpleWindow(display,rootwin,
			icons_win.width+2*border_width,
			message_win.height+2*border_width,
			search_win.width,search_win.height,
			border_width,border_color,background);
  XSelectInput(display, search_win.window,
	       ButtonPressMask|KeyPressMask|ExposureMask);
  search_win.gc=XCreateGC(display,search_win.window,
			  GCForeground|GCBackground|GCFont, &gc_values);
  XMapWindow(display,search_win.window);
    
  data_win.window =
    XCreateSimpleWindow(display,rootwin,
			icons_win.width+2*border_width,
			message_win.height+search_win.height+4*border_width,
			data_win.width,data_win.height,
			border_width,border_color,background);
  XSelectInput(display, data_win.window,
	       ButtonPressMask|KeyPressMask|ExposureMask);
  data_win.gc=XCreateGC(display,data_win.window,
			GCForeground|GCBackground|GCFont, &gc_values);
  XMapWindow(display,data_win.window);
    
  index_win.window =
    XCreateSimpleWindow(display,rootwin,
			0, control_win.height+icons_win.height+4*border_width,
			index_win.width,index_win.height,
			border_width,border_color,background);
  XSelectInput(display, index_win.window, ButtonPressMask|ExposureMask);
  index_win.gc=XCreateGC(display,index_win.window,
			 GCForeground|GCBackground|GCFont, &gc_values);
  XMapWindow(display,index_win.window);
    
  coord_win.window =
    XCreateSimpleWindow(display,rootwin,
			0,
			control_win.height+icons_win.height
			+index_win.height+6*border_width,
			coord_win.width,coord_win.height,
			border_width,border_color,background);
  XSelectInput(display, coord_win.window, ExposureMask);
  coord_win.gc=XCreateGC(display,coord_win.window,
			 GCForeground|GCBackground|GCFont, &gc_values);
  XMapWindow(display,coord_win.window);
    
  background=NUM_GREY_LEVELS/2;
    

  icons_win.window =
    XCreateSimpleWindow(display,rootwin,
			0,
			control_win.height+2*border_width,
			icons_win.width, icons_win.height,
			border_width,border_color,background);
  XSelectInput(display, icons_win.window, ButtonPressMask|ExposureMask);
  /* Create icon GCs */
  gc_values.fill_style=FillStippled;
  icons_win.gc=XCreateGC(display,icons_win.window, 0, &gc_values);
  icons_stip_gc=XCreateGC(display,icons_win.window, GCFillStyle, &gc_values);
  XMapWindow(display,icons_win.window);

    
  image_win.window =
    XCreateSimpleWindow(display,rootwin,
			index_win.width+2*border_width,
			control_win.height+icons_win.height+4*border_width,
			image_win.width,image_win.height,
			border_width,border_color,background);
  XSelectInput(display, image_win.window, KeyPressMask | ButtonPressMask|
	       ButtonReleaseMask|PointerMotionMask|LeaveWindowMask|
	       ExposureMask);
  XDefineCursor(display,image_win.window,arrow_cursor);
  /* Create image GCs */
  gc_values.line_style=LineOnOffDash;
  gc_values.fill_style=FillStippled;
  image_win.gc=XCreateGC(display,image_win.window, 0, &gc_values);
  image_stip_gc=XCreateGC(display,image_win.window, GCFillStyle, &gc_values);
  image_dash_gc=XCreateGC(display,image_win.window, GCLineStyle, &gc_values);
  gc_values.foreground=255;
  gc_values.function=GXxor;
  gc_values.plane_mask=NUM_GREY_LEVELS;
  image_xor_stip_gc=XCreateGC(display,image_win.window,
			 GCPlaneMask|GCFunction|GCForeground|GCFillStyle,
			 &gc_values);
  image_xor_dash_gc=XCreateGC(display,image_win.window,
			 GCPlaneMask|GCFunction|GCForeground|GCLineStyle,
			 &gc_values);
  image_handle_gc=XCreateGC(display,image_win.window,
			 GCPlaneMask|GCFunction|GCForeground,
			 &gc_values);
  XMapWindow(display,image_win.window);

  /* Stipple pixmaps */

  icons_stipple_data = (char *) calloc (icon_nrc_max, sizeof(char));
  MCHECK(icons_stipple_data);
  image_stipple_data = (char *) calloc (image_nrc_max, sizeof(char));
  MCHECK(image_stipple_data);

  for (i=0; i<NUM_STRENGTHS; i++) {

    convert_template_to_data(i, icons_stipple_data,
			     icon_width_max, icon_height_max);
    icons_stipple_pixmap[i]=XCreateBitmapFromData(display,icons_win.window,
						  icons_stipple_data,
						  icon_width_max,
						  icon_height_max);

    convert_template_to_data(i, image_stipple_data,
			     image_width_max, image_height_max);
    image_stipple_pixmap[i]=XCreateBitmapFromData(display,image_win.window,
						  image_stipple_data,
						  image_width_max,
						  image_height_max);

    dashes[i] = (unsigned char *) calloc (2, sizeof(unsigned char));
    MCHECK(dashes[i]);
    dashes[i][0] = 3*(i+1);
    dashes[i][1] = 2*((NUM_STRENGTHS-1) - i);
  }
  free(icons_stipple_data);
  free(image_stipple_data);

  set_xor_stipple();

  /* analyze pixmap */
    
  analyze_pixmap=XCreatePixmap(display,image_win.window,
			       image_width_max,image_height_max,8);
  gc_values.foreground=1;
  pixmap_gc=XCreateGC(display,analyze_pixmap,GCForeground, &gc_values);

  /* ximage structs */
    
  xdata=(byte *)malloc(colorstrip_width*colorstrip_height);
  MCHECK(xdata);
  init_colorstrip(xdata);
  colorstrip_ximage=XCreateImage(display,visual,8,ZPixmap,0,xdata,
				 colorstrip_width,colorstrip_height,8,0);

  search_ximage=XGetImage(display, analyze_pixmap,0,0,
			  icon_width_max,icon_height_max,
			  AllPlanes,ZPixmap);
  data_ximage=XGetImage(display, analyze_pixmap,0,0,
			icon_width_max,icon_height_max,
			AllPlanes,ZPixmap);
  
  /* init images */

  fprintf(stderr, "Normalizing images");
    
  divs=256/NUM_GREY_LEVELS;
    
  for (i=0; i<num_images; i++) {

    fprintf(stderr, ".");

    for (j=0; j<image[i].nrc; j++)
      image[i].data[j]=image[i].data[j]>>2;
    if (image[i].overlay)
      for (j=0; j<image[i].nrc; j++)
	image[i].overlay[j]=image[i].overlay[j]>>2;

    for (j=0; j<icon[i].nrc; j++)
      icon[i].data[j]=icon[i].data[j]>>2;
    if (icon[i].overlay)
      for (j=0; j<icon[i].nrc; j++)
	icon[i].overlay[j]=icon[i].overlay[j]>>2;
  }
  fprintf(stderr, "\n");
    
  /* set image window to injection mode */
    
  set_inj_or_label_mode(INJECTION);
}
