/* 
 * routines for polygon drawing and manipulation 
 *
 * Copyright 1994, 1995 Bill Press and Bruno Olshausen
 * Washington University School of Medicine
 *
 */

#include <stdio.h>
#include "xanat.h"
#include "ui.h"
#include "ui_objects.h"

init_polygon(poly,x,y)
    Polygon *poly;
    int	x,y;
{
  set_pos(&(poly->points[0]),x,y);
  set_pos(&(poly->points[1]),x,y);
  poly->num_points=2;
}

inc_polygon_pos(poly,d)
    Polygon	*poly;
    XPoint	*d;
{
  register int	i;

  for (i=0; i<poly->num_points; i++)
    inc_pos(&(poly->points[i]),d);
}

int compare_polygons (Polygon *poly1, Polygon *poly2)
{
  int i, mismatch;

  if (poly1->num_points == poly2->num_points) {
    for (i=0, mismatch=0; i<poly1->num_points; i++)
      if (poly1->points[i].x != poly2->points[i].x ||
	  poly1->points[i].y != poly2->points[i].y)
	mismatch = 1;
    if (mismatch == 0)
      return (1);
  }
  return (0);
}

within_polygon_p(poly,x,y)
    Polygon	*poly;
    int	x,y;
{
  static Region	r=NULL;

  if (r)
    XDestroyRegion(r);

  r=XPolygonRegion((XPoint *)poly->points,poly->num_points,WindingRule);
  return(XPointInRegion(r,x,y));
}

compute_polygon_icon_bounding_box(poly,box)
    Polygon	*poly;
    Box	*box;
{
  int		i;
  PixPoint	ul,lr,*pnt;

  ul.x=lr.x=poly->points[0].x;
  ul.y=lr.y=poly->points[0].y;

  pnt=poly->points+1;
  for (i=1; i<poly->num_points; i++) {
    if (pnt->x < ul.x)
      ul.x=pnt->x;
    if (pnt->y < ul.y)
      ul.y=pnt->y;
    if (pnt->x > lr.x)
      lr.x=pnt->x;
    if (pnt->y > lr.y)
      lr.y=pnt->y;
    pnt++;
  }
  scale_pos(&box->ul,&ul,ICON_SF);
  scale_pos(&box->lr,&lr,ICON_SF);
}


process_polygon_press(x,y,b)
    int	x,y,b;
{
  switch (move_mode) {
   case NULL_MODE:
    new_object(x,y);
    move_mode=STRETCH_MODE;
    polygon_finished_p=0;
    break;
   case STRETCH_MODE:
    add_polygon_point(selected_object,x,y,b);
    break;
  }
}

add_polygon_point(poly,x,y,b)
    Polygon	*poly;
    int	x,y,b;
{
  switch (b) {
   case Button1:
    if (poly->num_points==2)
      draw_polygon(poly);
    set_pos(&(poly->points[poly->num_points-1]),x,y);
    set_pos(&(poly->points[poly->num_points++]),x,y);
    break;
   case Button3:
    draw_polygon(poly);
    set_pos(&(poly->points[poly->num_points-1]),
	    poly->points[0].x,poly->points[0].y);
    polygon_finished_p=1;
    draw_polygon(poly);
    break;
  }  
}

process_polygon_move(x,y)
    int	x,y;
{
  if (move_mode==STRETCH_MODE  && !polygon_finished_p)
    stretch_polygon(selected_object,x,y,
		    ((Polygon *)selected_object)->num_points-1);
}

stretch_polygon(poly,x,y,i)
    Polygon	*poly;
    int	x,y,i;
{
  draw_polygon(poly);
  set_pos(&(poly->points[i]),x,y);
  if (i==0)
    set_pos(&(poly->points[poly->num_points-1]),x,y);
  draw_polygon(poly);
}


draw_polygon(poly)
    Polygon *poly;
{
  XPoint	lpoints[MAX_NUM_POLYGON_VERTICES];
  GC		gc;
  register int	i;

  extern int get_object_color();

  for (i=0; i<poly->num_points; i++) {
    lpoints[i].x=
      (reverse_mode) ? reverse(poly->points[i].x) : poly->points[i].x;
    lpoints[i].y=poly->points[i].y;
  }

  if (selected_object == (Object *) poly || is_analysis)
    if (!fill_mode)
      gc=image_xor_dash_gc;
    else
      gc=image_xor_stip_gc;
  else {
    if (!fill_mode) {
      gc=image_dash_gc;
      if (poly->header.strength!=(NUM_STRENGTHS-1)) {
	XSetLineAttributes(display, gc, 0, LineOnOffDash, CapButt, JoinMiter);
	XSetDashes(display, gc, 0, dashes[poly->header.strength], 2);
      }
      else
	XSetLineAttributes(display, gc, 0, LineSolid, CapButt, JoinMiter);
    }
    else {
      gc=image_stip_gc;
      XSetStipple(display, gc, image_stipple_pixmap[poly->header.strength]);
    }
    XSetForeground(display, gc, get_object_color(poly->header.type,
						 poly->header.inj_num));
  }

  if (!fill_mode || poly->num_points<3)
    XDrawLines(display,image_win.window,gc,
	       lpoints,poly->num_points,CoordModeOrigin);
  else
    XFillPolygon(display,image_win.window,gc,
		 lpoints,poly->num_points,Nonconvex,CoordModeOrigin);
}

draw_polygon_in_icon(poly,image_num)
    Polygon *poly;
    int	image_num;
{
  XPoint		lpoints[MAX_NUM_POLYGON_VERTICES];
  register XPoint 	*p1;
  register PixPoint	*p2;
  PixPoint		offset;
  register int		i;

  extern int get_object_color();

  p1=lpoints;
  p2=poly->points;
  offset.x=icon_pos[image_num].x;
  offset.y=icon_pos[image_num].y;
  for (i=0; i<poly->num_points; i++) {
    scale_pos(p1,p2,ICON_SF);
    p1->x = (reverse_mode) ? icon_reverse(p1->x, image_num) : p1->x;
    inc_pos(p1,&offset);
    p1++; p2++;
  }

  XSetForeground(display,icons_stip_gc,get_object_color(poly->header.type,
							poly->header.inj_num));
  XSetStipple(display,icons_stip_gc,icons_stipple_pixmap[poly->header.strength]);
  XFillPolygon(display,icons_win.window,icons_stip_gc,
	       lpoints,poly->num_points,Nonconvex,CoordModeOrigin);
}



draw_polygon_in_icon_pixmap(poly, fill)
    Polygon *poly;
{
  XPoint		lpoints[MAX_NUM_POLYGON_VERTICES];
  register XPoint 	*p1;
  register PixPoint	*p2;
  register int		i;

  p1=lpoints;
  p2=poly->points;
  for (i=0; i<poly->num_points; i++) {
    scale_pos(p1,p2++,ICON_SF);
    p1->x = p1->x;
    p1++;
  }

  XSetForeground(display,pixmap_gc,poly->header.strength+1);

  if (fill)
    XFillPolygon(display,analyze_pixmap, pixmap_gc,
		 lpoints,poly->num_points,Nonconvex,CoordModeOrigin);
  else
    XDrawLines(display,analyze_pixmap, pixmap_gc,
	       lpoints,poly->num_points,CoordModeOrigin);
}


set_polygon_handle_bars(poly)
    Polygon	*poly;
{
  int	i;

  for (i=0; i<poly->num_points-1; i++)
    set_pos(&bar[i],
	    poly->points[i].x-BAR_SIZE/2,
	    poly->points[i].y-BAR_SIZE/2);

  if (reverse_mode) {
    for (i=0; i<poly->num_points-1; i++)
      bar[i].x=reverse(bar[i].x+BAR_SIZE);
  }
}


num_polygon_handles(poly)
    Polygon	*poly;
{
  return(poly->num_points-1);
}
