/*
 * routines for processing text input
 *
 * Copyright 1994, 1995 Bruno Olshausen and Bill Press
 * Washington University School of Medicine
 *
 */

#include <stdio.h>

#include "xanat.h"
#include "ui.h"
#include "ui_text.h"

char	string[CHARS_PER_COMMENTS];
int	field_selected_p=0;

static int	field_index,ch_index;
static Coord	text_pos;



draw_text_pos(obj)
    win_obj	*obj;
{
  XDrawString(display,obj->window,obj->gc, text_pos.x, text_pos.y,
	      TEXT_MARK,strlen(TEXT_MARK));
}

erase_text_pos(obj)
    win_obj	*obj;
{
  XDrawImageString(display,obj->window,obj->gc, text_pos.x, text_pos.y,
		   ERASE_MARK,strlen(ERASE_MARK));
}

clear_to_endline(obj)
    win_obj	*obj;
{
  int	i;

  i=text_pos.x;
  while(i<obj->width) {
    XDrawImageString(display,obj->window,obj->gc,i,text_pos.y,
		     ERASE_MARK,strlen(ERASE_MARK));
    i+=medium_font.width;
  }
}


new_field(obj,x,y)
    win_obj	*obj;
    int	x,y;
{
  int	num_items,min_x,min_y,ch_posx,ch_posy,len,chars_per_line;

  if (field_selected_p)
    text_return(obj);

  y-=FIELD_BEGIN_Y;
  field_index=y/FIELD_STEP;

  field_selected_p=0;
  if (obj==&data_win) {
    if (field_index>=0 && field_index<NUM_DATA_ITEMS &&
	field_index!=1 && field_index!=2)
      field_selected_p=1;
  }
  else {
    if (field_index>=0 && field_index<NUM_SEARCH_ITEMS)
      field_selected_p=1;
  }

  if (field_selected_p) {
    if (obj==&data_win)
      datum2str(selected_datum[view_mode],field_index,string);
    else
      search2str(&search_fields,field_index,string);
    len=strlen(string);
    min_x=FIELD_BEGIN_X+str_pix_len(INDENT,&medium_font);
    min_y=field_index*FIELD_STEP+BUFF;
    chars_per_line=(data_win.width-min_x)/medium_font.width;
    if (len) {
      ch_posx=(x>min_x) ? (x-min_x)/medium_font.width : 0;
      ch_posx = (ch_posx>=chars_per_line) ? chars_per_line-1 : ch_posx;
      ch_posy=(y>min_y) ? (y-min_y)/medium_font.height : 0;
      ch_index=ch_posy*chars_per_line + ch_posx;
      ch_index=(ch_index<len) ? ch_index : len-1;
    }
    else {
      ch_index=0;
    }
    text_pos.x=min_x+medium_font.width*(ch_index%chars_per_line);
    text_pos.y=
      FIELD_BEGIN_Y+min_y+medium_font.height*(1+ch_index/chars_per_line);
    clear_to_endline(obj);
    draw_text_pos(obj);
  }
}

process_character(obj,ch)
    win_obj	*obj;
    char	*ch;
{
  int	next_x;

  XDrawImageString(display,obj->window,obj->gc,text_pos.x,text_pos.y,ch,1);
  string[ch_index++]=*ch;
  next_x = text_pos.x + medium_font.width;
  if (next_x+medium_font.width < obj->width)
    text_pos.x=next_x;
  else {
    text_pos.x=FIELD_BEGIN_X+str_pix_len(INDENT,&medium_font);
    text_pos.y+=medium_font.height;
  }
  draw_text_pos(obj);
}

backspace(obj)
    win_obj	*obj;
{
  int	i;

  if (ch_index>0) {
    erase_text_pos(obj);
    text_pos.x-=medium_font.width;
    erase_text_pos(obj);
    draw_text_pos(obj);
    ch_index--;
  }
}

text_return(obj)
    win_obj	*obj;
{
  int	num_items;

  erase_text_pos(obj);

  string[ch_index]='\0';
  if (obj==&search_win)
    str2search(&search_fields,field_index,string);
  else  {
    str2datum(selected_datum[view_mode],field_index,string);
    if (field_index==0) {
      ref2abbrev(selected_datum[view_mode],string);
      renum_refs(DATA);
      redraw_index_win();
    }
  }

  field_selected_p=0;
}



/* message window */

#include <X11/keysym.h>

pmes(s)
    char	*s;
{
  text_pos.x=FIELD_BEGIN_X;
  text_pos.y=message_win.height-10;
  clear_to_endline(&message_win);
  XDrawString(display,message_win.window,message_win.gc,
	      text_pos.x,text_pos.y,s,strlen(s));
  XFlush(display);
  text_pos.x += str_pix_len(s,&medium_font);
  wrote_message=1;
}

perr(s)
    char	*s;
{
  fprintf(stderr,"\a");
  pmes(s);
}

char *query(s)
    char	*s;
{ 
  int		done;
  char		ch[10];
  XEvent	event;
  KeySym 	keysym;

  perr(s);
  draw_text_pos(&message_win);
  ch_index=0;
  done=0;
  while(!done) {
    XWindowEvent(display,message_win.window,KeyPressMask,&event);
    XLookupString((XKeyPressedEvent *)&event, ch, sizeof(ch), &keysym, NULL);
    if (keysym==XK_Return)
      done=1;
    else if ((keysym==XK_Delete) || (keysym==XK_BackSpace))
      backspace(&message_win);
    else if ((keysym>=XK_space)&&(keysym<=XK_asciitilde))
      process_character(&message_win,ch);
  }
  string[ch_index]='\0';
  text_pos.x=FIELD_BEGIN_X;
  clear_to_endline(&message_win);
  return(string);
}
