/*  
 * xanat.c:	An graphical database program for storing and comparing
 *		data from neuroanatomical injection studies
 *
 * Copyright 1994, 1995 Bill Press and Bruno Olshausen
 * Washington University School of Medicine
 *
 */

#include <stdio.h>

#include "xanat.h"

Image		*image, *icon;
int		num_images;
int		current_image=0;

int		image_width_max,image_height_max,image_nrc_max;
int		icon_width_max,icon_height_max,icon_nrc_max;

Datum		*list[NUM_LISTS];
Datum		*selected_datum[NUM_LISTS];
Object		*selected_object=NULL;

int		index_page[NUM_MODES];
int		num_datums_per_index_page=20;

searchType 	search_fields={"","","",""};

AreaDef		*area_list=NULL;

int		wrote_message=0;

int		bigEndian;

/* modes */

int		is_analysis=0;
int		is_stack=0;

int		draw_mode=SELECTION_MODE;
int		reverse_mode=0;
int		fill_mode=1;

int		image_mode=IMAGE;
int		analysis_type=SUPERPOSITION;
int		view_mode=DATA;
int		object_mode=INJECTION;
int		strength_num=(NUM_STRENGTHS-1)/2;
int		inject_num=0;
int		inject_toggles[NUM_DIFF_INJ];


main(argc,argv)
    int	argc;
    char	**argv;
{

  
  init();			/* init program */

  setup_display();		/* init user interface */
  init_ui();

  compute_area_sizes();

  main_event_loop();		/* go */
}

fatal_error(s)
    char	*s;
{
  fprintf(stderr,"xanat: %s\n",s);
  exit(1);
}
