typedef unsigned char	byte;

#define MCHECK(m) 	if (!m) fatal_error("malloc failed");

#define VERSION 2.0
#define DATA_FILE_VERSION 2.0

/* general database parameters */
#define NUM_DIFF_INJ 2
#define NUM_STRENGTHS 5

/* datum type */
#define DATA_TYPE 0
#define ANALYSIS_TYPE 1

/* view and list modes */
#define DATA 0
#define SEARCH 1
#define STACK 2
#define ANALYSIS 3
#define COMPARE 4
#define OR 5

#define NUM_MODES 4 /* OR and COMPARE not view modes */
#define NUM_LISTS 6

/* draw modes */
#define SELECTION_MODE 0
#define DRAW_ELLIPSE_MODE 1
#define DRAW_POLYGON_MODE 2
#define DRAW_AREA_MODE 3
#define DRAW_FILL_MODE 4
#define REVERSE_MODE 5

/* image modes */
#define IMAGE 0
#define OVERLAY 1

/* editing */
#define ADD 0
#define DELETE 1

/* directions */
#define TO 0
#define FROM 1
#define EITHER 2

/* object_type */
#define INJECTION 0
#define LABEL 1
#define SEARCH_AREA 2
#define BOTH 3

/* injection flavor */
#define RETROGRADE 1
#define ANTEROGRADE 2

/* possible shapes */
#define ELLIPSE 0
#define POLYGON 1

/* polygon size limit */
#define MAX_NUM_POLYGON_VERTICES 50

/* file */
#define LOAD 0
#define SAVE 1

/* analysis method */
#define SUPERPOSITION 0
#define BAYES 1
#define SUBTRACTION 2
#define ADDITION 3
#define	MULTIPLICATION 4

#define	COMPARE_OFFSET 2
#define NUM_ANALYSES 5

/* text window limits */
#define NUM_DATA_ITEMS 6
#define NUM_SEARCH_ITEMS 4

#define CHARS_PER_AREA_LABEL 20
#define CHARS_PER_REF 80
#define CHARS_PER_ABBREV 20
#define CHARS_PER_COMMENTS 400

/* image/icon scale factor */
#define ICON_SF 4

/* The "datum" structure type completely describes any one injection.
 * 
 * Cortex is an array of cortical areas labelled by the injection -- each
 * area has an associated name (area), a number describing the fraction of
 * label falling within that area (fractLabel), and the list of labelled layers
 * (layer). Both cortex and layer will point to NULL after their last
 * element. The first element in layer will be NULL if laminar information
 * is unavailable.
 * 
 * Ellipse is an array of ellipses. These represent regions of labelling, 
 * and are described by the equation (x-x0)^2/a+(y-y0)^2/b=r^2. The number
 * of parameters have been reduced by one, though, by multiplying through
 * by b, giving (b/a)(x-x0)^2+(y-y0)^2=b*r^2, or scale*(x-x0)^2+(y-y0)^2=sRad.
 * 
 * Confidence represents the believability of the data, from a scale of 0
 * (no confidence at all) to 1 (extremely believable).
 * 
 * The injection site, injSite, is either 0 or 1 -- these correspond to either
 * cortical or pulvinar injections. LabelType is also either 0 or 1 -- these
 * correspond to either retrograde or anterograde labels.
 *  
 * Reference and comments are both self-explanatory. Reference does not contain
 * the title of the paper (for space reasons).
 * 
 * Next allows various structs to be represented as a linked list. This will be
 * implemented when performing a search on keywords. Stack allows the user
 * to create a flexible stack of data.
 */

typedef struct {
  short	x;
  short	y;
} PixPoint;

typedef struct {
  int		shape;
  int		type;
  int		size;
  int		strength;
  int		inj_num;
  union obj	*next;
} Header;

typedef struct {
  Header	header;
  PixPoint	upper_left;
  PixPoint	size;
} Ellipse;

typedef struct {
  Header	header;
  PixPoint	points[MAX_NUM_POLYGON_VERTICES];
  int	num_points;
} Polygon;

typedef union obj {
  Header	header;
  Ellipse	ellipse;
  Polygon	polygon;
} Object;

typedef struct areaType
{
  char			name[CHARS_PER_AREA_LABEL];
  double		fract;
  struct areaType	*next;
} Area;

typedef struct refType{
  char			full[CHARS_PER_REF];
  char			abbrev[CHARS_PER_ABBREV];
  char			comparison[10];
  int			num;
  struct refType	*next;
} Ref;

typedef struct datumType
{
  int		type;

  Area		*injAreas;
  Area		*labelAreas;
    
  Object	**objects;
  double	**heatmap;

  double	heatmap_min;
  double	heatmap_max;

  int		*validSlice;
  int		writeProtect;

  double	analysis_midpoint;

  int		confidence;
  int		labelType;
  char		comments[CHARS_PER_COMMENTS];
  Ref		ref;

  double	areaWeight;

  int			inAnalysis;
  int			analysisMethod;
  struct datumType	*compareFrom1, *compareFrom2;

  struct datumType	*next[NUM_LISTS];
  struct datumType	*prev[NUM_LISTS];
} Datum;

/* The "searchType" structure type contains the information necessary to
 * conduct a search. They are all input strings... the record selection
 * algorithm parses each of the strings to effect the appropriate search.
 * Direction must begin with either a "t" for to, or an "f" for from.
 * Area, reference, and comments must be a string of words. And layer is
 * a list of numbers (i.e. "1 3 6"). Whenever more than one element is in
 * a field, the search algorithm will look for records where they both occur.
 */

typedef struct
{
  char	direction[10];
  char	area[80];
  char	reference[CHARS_PER_REF];
  char	comments[CHARS_PER_COMMENTS];
} searchType;

typedef struct area_def {
  Object	**objects;
  char		name[CHARS_PER_AREA_LABEL];
  int		size;
  struct area_def *next;
} AreaDef;

typedef struct {
  PixPoint	ul;
  PixPoint	lr;
} Box;

typedef struct {
  double	x;
  double	y;
} StereotaxPoint;

typedef struct {
  byte	*data;
  byte	*overlay;
  int	width;
  int	height;
  int	nrc;
} Image;

extern Image		*image, *icon;
extern int		num_images;
extern int		current_image;

extern int		image_width_max,image_height_max,image_nrc_max;
extern int		icon_width_max,icon_height_max,icon_nrc_max;

extern Datum		*list[NUM_LISTS];
extern Datum		*selected_datum[NUM_LISTS];
extern Object		*selected_object;

extern int		index_page[NUM_MODES];
extern int		num_datums_per_index_page;

extern searchType	search_fields;

extern AreaDef		*area_list;

extern int		wrote_message;

extern int		bigEndian;

/* modes */

extern int		is_analysis;
extern int		is_stack;

extern int		draw_mode;
extern int		reverse_mode;
extern int		fill_mode;

extern int		image_mode;
extern int		analysis_type;
extern int		view_mode;
extern int		object_mode;
extern int		strength_num;
extern int		inject_num;
extern int		inject_toggles[NUM_DIFF_INJ];
