#include <stdio.h>

#include "control.h"
#include "graphics.h"

control_struct 	control[NUM_CONTROLS]={{"text",TEXT_ID},
				       {"doodle",DOODLE_ID},
				       {"point",POINT_ID},
				       {"line",LINE_ID},
				       {"box",BOX_ID},
				       {"circle",CIRCLE_ID},
				       {"eraser",ERASE_ID},
				       {"cut&paste",CUTNPASTE_ID},
				       {"clear all",CLEAR_ID},
				       {"quit",QUIT_ID}};

int		control_win_width=80, control_spacing;
int		action[N];
unsigned long	draw_event_mask,control_event_mask,
  		root_event_mask[N], paste_event_mask[N];


static XEvent	event;
static int	done_p;

main_event_loop()
{
  int	i;

  done_p=0;
  while (!done_p) {
    for (i=0; i<num_machines; i++) {
      if (XCheckMaskEvent(display[i], draw_event_mask|control_event_mask|
			  root_event_mask[i]|paste_event_mask[i], &event))
	process_event(i,&event);
    }
  }
}

process_event(machine,event)
int	machine;
XEvent	*event;
{
  switch ((int) event->type) {
  case ButtonPress:
    process_button_press(machine,event);
    break;
  case ButtonRelease:
    process_button_release(machine,event);
    break;
  case MotionNotify:
    process_motion(machine,event);
    break;
  case KeyPress:
    process_key_press(machine,event);
    break;
  case Expose:
    init_controls(machine);
    break;
  }
}


process_button_press(machine,button_event)
int		machine;
XButtonEvent	*button_event;
{
  int		index;
  Window	win;

  win=button_event->window;

  if (win==draw_win[machine]) {
    set_pen(machine,button_event->button);
    process_draw_win_button(machine,button_event->x,button_event->y);
  }
  else if (win==control_win[machine]) {
    index=button_event->y/control_spacing;
    do_control(machine,index);
  }
  else if (win==display_root_win[machine]) {
    set_cut_rect_origin(machine,button_event->x,button_event->y);
  }
}

set_pen(machine,button)
int		machine;
unsigned int	button;
{
  switch(button) {
  case Button1:
    pen[machine]=SMALL;
    break;
  case Button2:
    pen[machine]=MEDIUM;
    break;
  case Button3:
    pen[machine]=LARGE;
    break;
  }
}

process_draw_win_button(machine,x,y)
int		machine,x,y;
{
  switch (action[machine]) {
  case DOODLE_ACTION:
    start_doodle(machine,x,y);
    break;
  case ERASE_ACTION:
    erase(machine,x,y);
    break;
  case TEXT_ACTION:
    new_text_pos(machine,x,y);
    break;
  case LINE_ACTION:
    start_line(machine,x,y);
    break;
  case BOX_ACTION:
    start_box(machine,x,y);
    break;
  case CIRCLE_ACTION:
    start_box(machine,x,y);
    break;
  case POINT_ACTION:
    XDefineCursor(display[machine],draw_win[machine],hand_cursor[machine]);
    start_pointer(machine,x,y);
    break;
  case PASTE_ACTION:
    paste_image(machine,x,y);
    XSelectInput(display[machine], draw_win[machine],draw_event_mask);
    paste_event_mask[machine]=0;
    action[machine]=NULL_ACTION;
    XDefineCursor(display[machine],draw_win[machine],arrow_cursor[machine]);
    break;
  }
}


process_button_release(machine,button_event)
int		machine;
XButtonEvent	*button_event;
{
  Window	win;

  win=button_event->window;

  if (win==draw_win[machine]) {
    process_draw_win_release(machine,button_event->x,button_event->y);
  }
  else if (win==display_root_win[machine]) {
    process_display_root_win_release(machine,button_event->x,button_event->y);
  }
}

process_draw_win_release(machine,x,y)
int	machine,x,y;
{
  switch (action[machine]) {
  case LINE_ACTION:
    finish_line(machine,x,y);
    break;
  case BOX_ACTION:
    finish_box(machine,x,y);
    break;
  case CIRCLE_ACTION:
    finish_circle(machine,x,y);
    break;
  case POINT_ACTION:
    XDefineCursor(display[machine],draw_win[machine],arrow_cursor[machine]);
    xor_pointer(machine);
    break;
  }
}

process_display_root_win_release(machine,x,y)
int	machine,x,y;
{
  /* first get rid of control button release, then finish cut rectangle */
  if (org[machine].x!=NULL_PNT) {
    ungrab_pointer(machine);
    if (finish_cut_rectangle(machine,x,y)) {
      action[machine]=PASTE_ACTION;
      XDefineCursor(display[machine],draw_win[machine],cross_cursor[machine]);
      paste_event_mask[machine]=PointerMotionMask;
      XSelectInput(display[machine], draw_win[machine],
		   draw_event_mask|paste_event_mask[machine]);
      org[machine].x=NULL_PNT;
    }
    else {
      draw_message(machine,"failed to get image... try again");
      action[machine]=NULL_ACTION;
    }
  }
}
      
process_motion(machine,motion_event)
int		machine;
XMotionEvent	*motion_event;
{
  Window	win,root,child;
  int		rootx,rooty,posx,posy;
  unsigned int	kbut;

  win=motion_event->window;

  if (XQueryPointer(display[machine],win,&root,&child,&rootx,&rooty,
		     &posx,&posy,&kbut)) {

    if (win==draw_win[machine])
      process_draw_win_motion(machine,posx,posy);
    else if ((win==display_root_win[machine]) && (org[machine].x!=NULL_PNT))
      draw_intermediate_cut_rect(machine,posx,posy);
  }
}

process_draw_win_motion(machine,x,y)
int		machine,x,y;
{
  switch (action[machine]) {
  case DOODLE_ACTION:
    draw_doodle(machine,x,y);
    break;
  case ERASE_ACTION:
    erase(machine,x,y);
    break;
  case LINE_ACTION:
    draw_intermittant_line(machine,x,y);
    break;
  case BOX_ACTION:
    draw_intermittant_box(machine,x,y);
    break;
  case CIRCLE_ACTION:
    draw_intermittant_circle(machine,x,y);
    break;
  case POINT_ACTION:
    draw_pointer(machine,x,y);
    break;
  case PASTE_ACTION:
    draw_paste_rect(machine,x,y);
    break;
  }
}


#include <X11/keysym.h>

process_key_press(machine,key_event)
int		machine;
XKeyEvent 	*key_event;
{
  char	kbuf[10];
  KeySym keysym;

  if (key_event->window==draw_win[machine]) {
    XLookupString(key_event, kbuf, sizeof(kbuf), &keysym, NULL);
    process_keysym(keysym,kbuf,machine);
  }
}

process_keysym(keysym,ch,machine)
KeySym	keysym;
char	*ch;
int	machine;
{
 if (keysym==XK_Return)
   text_return(machine);
 else if (keysym==XK_Delete)
   backspace(machine);
 else if ((keysym>=XK_space)&&(keysym<=XK_asciitilde))
   draw_character(machine,ch);
}


do_control(machine,index)
int	machine,index;
{
  switch(control[index].id) {
  case TEXT_ID:
    action[machine]=TEXT_ACTION;
    set_draw_win_cursor(machine);
    break;
  case DOODLE_ID:
    action[machine]=DOODLE_ACTION;
    set_draw_win_cursor(machine);
    break;
  case POINT_ID:
    action[machine]=POINT_ACTION;
    set_draw_win_cursor(machine);
    break;    
  case ERASE_ID:
    action[machine]=ERASE_ACTION;
    set_draw_win_cursor(machine);
    break;
  case LINE_ID:
    action[machine]=LINE_ACTION;
    set_draw_win_cursor(machine);
    break;
  case BOX_ID:
    action[machine]=BOX_ACTION;
    set_draw_win_cursor(machine);
    break;
  case CIRCLE_ID:
    action[machine]=CIRCLE_ACTION;
    set_draw_win_cursor(machine);
    break;
  case CUTNPASTE_ID:
    grab_pointer(machine);
    action[machine]=CUT_ACTION;
    org[machine].x=NULL_PNT;
    break;
  case CLEAR_ID:
    clear_windows();
    break;
  case QUIT_ID:
    done_p=1;
  }
}

set_draw_win_cursor(machine)
int	machine;
{
  int	act;

  act=action[machine];

  if (act==TEXT_ACTION)
    XDefineCursor(display[machine],draw_win[machine],text_cursor[machine]);
  else if (act==DOODLE_ACTION)
    XDefineCursor(display[machine],draw_win[machine],doodle_cursor[machine]);
  else if (act==POINT_ACTION)
    XDefineCursor(display[machine],draw_win[machine],arrow_cursor[machine]);
  else if ((act==LINE_ACTION) || (act==CIRCLE_ACTION) || (act==BOX_ACTION))
    XDefineCursor(display[machine],draw_win[machine],cross_cursor[machine]);
  else if (act==ERASE_ACTION)
    XDefineCursor(display[machine],draw_win[machine],erase_cursor[machine]);
}

grab_pointer(machine)
int	machine;
{
  int 		status;

  /* Grab the pointer using target cursor, letting it roam all over */
  root_event_mask[machine]=ButtonPressMask|ButtonReleaseMask|
			   Button1MotionMask|PointerMotionHintMask;
  status = XGrabPointer(display[machine], display_root_win[machine], False,
			root_event_mask[machine], GrabModeAsync, GrabModeAsync,
			display_root_win[machine], cross_cursor[machine],
			CurrentTime);
  if (status != GrabSuccess) {
    perr("Can't grab the mouse!");
    return;
  }
}

ungrab_pointer(machine)
int	machine;
{
  XUngrabPointer(display[machine], CurrentTime);
  root_event_mask[machine]=0;
}
