#include <stdio.h>
#include "graphics.h"

str_pix_len(machine,pen_no,string)
int	machine,pen_no;
char	*string;
{
  return(XTextWidth(font_info[machine][pen_no],string,strlen(string)));
}

clear_windows()
{
  int	i;

  for (i=0; i<num_machines; i++)
    XClearWindow(display[i],draw_win[i]);
}


/* doodle stuff */

static Coord	draw_pos[N];

start_doodle(machine,x,y)
int	machine,x,y;
{
  draw_pos[machine].x=x;
  draw_pos[machine].y=y;
}

draw_doodle(machine,x,y,pen_no)
int	machine,x,y,pen_no;
{
  int	i;

  for (i=0; i<num_machines; i++)
    XDrawLine(display[i],draw_win[i],draw_gc[i][pen[machine]],
	      draw_pos[machine].x,draw_pos[machine].y,x,y);
  draw_pos[machine].x=x;
  draw_pos[machine].y=y;
}


/* eraser */

#define ESIZE 13

erase(machine,x,y)
int	x,y;
{
  int	i,size;
  
  size=ESIZE*(1<<pen[machine]);
  for (i=0; i<num_machines; i++)
    XClearArea(display[i],draw_win[i],x-size/2,y-size/2,size,size,False);
}


/* text stuff */

#define TEXT_MARK "_"

draw_text_pos(machine)
int	machine;
{
  XDrawImageString(display[machine],draw_win[machine],
		   draw_gc[machine][pen[machine]],
		   text_pos[machine].x,text_pos[machine].y,
		   TEXT_MARK,strlen(TEXT_MARK));
}

#define ERASE_MARK " "

erase_text_pos(machine)
int	machine;
{
  XDrawImageString(display[machine],draw_win[machine],
		   draw_gc[machine][pen[machine]],
		   text_pos[machine].x,text_pos[machine].y,
		   ERASE_MARK,strlen(ERASE_MARK));
}

set_text_pos(machine,x,y)
int	machine,x,y;
{
  text_pos[machine].x=x;
  text_pos[machine].y=y;
}

new_text_pos(machine,x,y)
int	machine,x,y;
{
  erase_text_pos(machine);
  set_text_pos(machine,x,y);
  draw_text_pos(machine);

  return_pos[machine].x=x;
}

draw_character(machine,ch)
int	machine;
char	*ch;
{
  int	i,next_x;

  for (i=0; i<num_machines; i++) {
    XDrawImageString(display[i],draw_win[i],draw_gc[i][pen[machine]],
		     text_pos[machine].x,text_pos[machine].y,ch,1);
  }
  next_x = text_pos[machine].x + horiz_space[pen[machine]];
  if (next_x+horiz_space[pen[machine]] < draw_win_width)
    set_text_pos(machine,next_x,text_pos[machine].y);
  else
    set_text_pos(machine,0,text_pos[machine].y+
		 text_ascent[pen[machine]]+text_descent[pen[machine]]);

  draw_text_pos(machine);
}

backspace(machine)
int	machine;
{
  int	i;

  erase_text_pos(machine);
  set_text_pos(machine,text_pos[machine].x-horiz_space[pen[machine]],
	       text_pos[machine].y);
  for (i=0; i<num_machines; i++)
    XDrawImageString(display[i],draw_win[i],draw_gc[i][pen[machine]],
		     text_pos[machine].x,text_pos[machine].y,
		     ERASE_MARK,strlen(ERASE_MARK));
  draw_text_pos(machine);
}

text_return(machine)
int	machine;
{
  erase_text_pos(machine);
  set_text_pos(machine,return_pos[machine].x,text_pos[machine].y+
	       text_ascent[pen[machine]]+text_descent[pen[machine]]);
  draw_text_pos(machine);
}


/* line drawing */

static Coord	p1[N], p2[N];

start_line(machine,x,y)
int	machine,x,y;
{
  p1[machine].x=p2[machine].x=x;
  p1[machine].y=p2[machine].y=y;
}

draw_intermittant_line(machine,x,y)
int	machine,x,y;
{
  XDrawLine(display[machine],draw_win[machine],draw_gc_xor[machine],
	    p1[machine].x,p1[machine].y,p2[machine].x,p2[machine].y);
  XDrawLine(display[machine],draw_win[machine],draw_gc_xor[machine],
	    p1[machine].x,p1[machine].y,x,y);
  p2[machine].x=x;
  p2[machine].y=y;
}

finish_line(machine,x,y)
int	machine,x,y;
{
  int	i;

  XDrawLine(display[machine],draw_win[machine],draw_gc_xor[machine],
	    p1[machine].x,p1[machine].y,p2[machine].x,p2[machine].y);

  for (i=0; i<num_machines; i++)
    XDrawLine(display[i],draw_win[i],draw_gc[i][pen[machine]],
	      p1[machine].x,p1[machine].y,x,y);
}


/* box drawing */

start_box(machine,x,y)
int	machine,x,y;
{
  org[machine].x=x;
  org[machine].y=y;
  size[machine].x=0;
  size[machine].y=0;
}

draw_intermittant_box(machine,x,y)
int	machine,x,y;
{
  xor_rect(machine);
  set_size(machine,x,y);
  xor_rect(machine);
}

finish_box(machine,x,y)
int	machine,x,y;
{
  int	i;

  xor_rect(machine);
  set_size(machine,x,y);
  for (i=0; i<num_machines; i++)
    XDrawRectangle(display[i],draw_win[i],draw_gc[i][pen[machine]],
		   org[machine].x,org[machine].y,
		   size[machine].x,size[machine].y);
}

xor_rect(machine)
int	machine;
{
  XDrawRectangle(display[machine],draw_win[machine],draw_gc_xor[machine],
		 org[machine].x,org[machine].y,
		 size[machine].x,size[machine].y);
}

set_size(machine,x,y)
int	machine,x,y;
{
  if ((size[machine].x = x - org[machine].x) < 0)
    size[machine].x=0;
  if ((size[machine].y = y - org[machine].y) < 0)
    size[machine].y=0;
}


/* circle drawing */

draw_intermittant_circle(machine,x,y)
int	machine,x,y;
{
  XDrawArc(display[machine],draw_win[machine],draw_gc_xor[machine],
	   org[machine].x,org[machine].y,size[machine].x,size[machine].y,
	   0,23040);
  set_size(machine,x,y);
  XDrawArc(display[machine],draw_win[machine],draw_gc_xor[machine],
	   org[machine].x,org[machine].y,size[machine].x,size[machine].y,
	   0,23040);
}

finish_circle(machine,x,y)
int	machine,x,y;
{
  int	i;

  XDrawArc(display[machine],draw_win[machine],draw_gc_xor[machine],
	   org[machine].x,org[machine].y,size[machine].x,size[machine].y,
	   0,23040);
  set_size(machine,x,y);
  for (i=0; i<num_machines; i++)
    XDrawArc(display[i],draw_win[i],draw_gc[i][pen[machine]],
	     org[machine].x,org[machine].y,size[machine].x,size[machine].y,
	     0,23040);
}


/* remote pointer stuff */

static Coord	p[N];

start_pointer(machine,x,y)
int	machine,x,y;
{
  p[machine].x=x; p[machine].y=y;
  xor_pointer(machine);
}

draw_pointer(machine,x,y)
int	machine,x,y;
{
  xor_pointer(machine);
  p[machine].x=x; p[machine].y=y;
  xor_pointer(machine);
}

xor_pointer(machine)
int	machine;
{
  int	i;

  for (i=0; i<num_machines; i++) {
    if (i!=machine) {
      XPutImage(display[i],draw_win[i],draw_gc_xor[i],pointer_ximage[i],
		0,0,p[machine].x,p[machine].y,POINTER_WIDTH,POINTER_HEIGHT);
    }
  }
}


/* cut and paste */

static XImage	*cut_ximage[N];

set_cut_rect_origin(machine,x,y)
int	machine,x,y;
{
  org[machine].x=x;
  org[machine].y=y;
  size[machine].x=0;
  size[machine].y=0;
}

draw_intermediate_cut_rect(machine,x,y)
int	machine,x,y;
{
  xor_cut_rect(machine);
  set_size(machine,x,y);
  xor_cut_rect(machine);
}

finish_cut_rectangle(machine,x,y)
int	machine,x,y;
{
  xor_cut_rect(machine);
  set_size(machine,x,y);

  if (cut_ximage[machine]!=NULL)
    XDestroyImage(cut_ximage[machine]);
  if ((cut_ximage[machine]=
       XGetImage(display[machine],display_root_win[machine],
		 org[machine].x,org[machine].y,size[machine].x,size[machine].y,
		 AllPlanes,ZPixmap)) != NULL)
    return(1);
  else
    return(0);
}

xor_cut_rect(machine)
int	machine;
{
  XDrawRectangle(display[machine],display_root_win[machine],
		 display_root_gc[machine],org[machine].x,org[machine].y,
		 size[machine].x,size[machine].y);
}

draw_paste_rect(machine,x,y)
int	machine,x,y;
{
  if (org[machine].x!=NULL_PNT)
    xor_rect(machine);
  org[machine].x=x-size[machine].x/2;
  org[machine].y=y-size[machine].y/2;
  xor_rect(machine);
}

paste_image(machine,x,y)
int	machine,x,y;
{
  int		i;
  unsigned	width,height,depth;
  int		format,offset,bitmap_pad;
  byte		*data_copy;

  xor_rect(machine);

  width=cut_ximage[machine]->width;
  height=cut_ximage[machine]->height;
  depth=cut_ximage[machine]->depth;
  format=cut_ximage[machine]->format;
  offset=cut_ximage[machine]->xoffset;
  bitmap_pad=cut_ximage[machine]->bitmap_pad;

  XPutImage(display[machine],draw_win[machine],draw_gc[machine][SMALL],
	    cut_ximage[machine],
	    0,0,org[machine].x,org[machine].y,width,height);

  data_copy=(byte *)malloc(cut_ximage[machine]->bytes_per_line*
			   cut_ximage[machine]->height);

  draw_message(machine,"wait a second, sending image...");
  for (i=0; i<num_machines; i++) {
    if (i!=machine) {
      if (cut_ximage[i]!=NULL)
	free(cut_ximage[i]);
      cut_ximage[i]=XCreateImage(display[i],visual[i],depth,format,offset,
				 data_copy,width,height, bitmap_pad,0);
      translate_colors(machine,i);
      XPutImage(display[i],draw_win[i],draw_gc[i][SMALL],cut_ximage[i],
		0,0,org[machine].x,org[machine].y,width,height);
    }
  }
  draw_message(machine,"done.                          ");
  
  free(data_copy);
}

#define MAX_COLORS 256
#define NO_COLOR -1
XColor	colors[MAX_COLORS];
static unsigned short	lmasks[8] =
{0xff00, 0xfe00, 0xfc00, 0xf800, 0xf000, 0xe000, 0xc000, 0x8000};

translate_colors(from_machine,to_machine)
int	from_machine,to_machine;
{
  Colormap	cmap;
  XColor	*defs;
  register int	i,j,strip,numcols;
  register byte	*d,*d_out;
  unsigned long	cols[MAX_COLORS],index;
  int		width,line_width,height;
  register unsigned short lmask;
  char		errmes[80];

  width=cut_ximage[from_machine]->width;
  line_width=cut_ximage[from_machine]->bytes_per_line;
  height=cut_ximage[from_machine]->height;

  numcols=0;
  for (j=0; j<height; j++) {
    d=(byte *)(cut_ximage[from_machine]->data + j*line_width);
    d_out=(byte *)(cut_ximage[to_machine]->data + j*line_width);
    for (i=0; i<width; i++) {
      if (numcols<MAX_COLORS) {
	if ((index=get_index(*d,numcols))==NO_COLOR) {
	  colors[numcols].pixel=*d;
	  *d_out++ = numcols;
	  numcols++;
	}
	else {
	  *d_out++ = index;
	}
	d++;
      }
      else {
	draw_message(to_machine,"too many colors - may look bad!!");
	break;
      }
    }
  }

  cmap=XDefaultColormap(display[from_machine],screen[from_machine]);
  XQueryColors(display[from_machine],cmap,colors,numcols);

  cmap=XDefaultColormap(display[to_machine],screen[to_machine]);
  defs=(XColor *)malloc(numcols*sizeof(XColor));
    
  j = 0;
  strip=0;
  while (strip<8) {
    lmask = lmasks[strip];
    for (i=0; i<numcols; i++) {
      defs[i].red   = colors[i].red  & lmask;
      defs[i].green = colors[i].green & lmask;
      defs[i].blue  = colors[i].blue & lmask;
      defs[i].flags = DoRed | DoGreen | DoBlue;
      if (!XAllocColor(display[to_machine],cmap,&defs[i])) break;
      cols[i] = defs[i].pixel;
    }

    if (i<numcols) {		/* failed */
      strip++;  j++;
      for (i--; i>=0; i--)
	XFreeColors(display[to_machine],cmap,&cols[i],1,0L);
    }
    else break;
  }

  if (j && strip<8) {
    sprintf(errmes,"stripped %d bits\n",strip);
    draw_message(to_machine,errmes);
  }
  else if (strip==8) {
    draw_message(to_machine,"UTTERLY failed to allocate the desired colors");
    for (i=0; i<numcols; i++) cols[i]=i;
  }

  for (j=0; j<height; j++) {
    d=(byte *)(cut_ximage[to_machine]->data + j*line_width);
    for (i=0; i<width; i++) {
      *d = cols[*d];
      d++;
    }
  }
}

get_index(pix,numcols)
int	pix,numcols;
{
  register int	i;

  for (i=0; i<numcols; i++) {
    if (pix==colors[i].pixel)
      return(i);
  }
  return(NO_COLOR);
}

draw_message(machine,s)
int	machine;
char	*s;
{
  XDrawImageString(display[machine],draw_win[machine],draw_gc[machine][SMALL],
		   10,10+text_ascent[SMALL],s,strlen(s));
  XFlush(display[machine]);
}

