#include <stdio.h>

#include "control.h"
#include "graphics.h"
#include <X11/cursorfont.h>
#include <X11/Xutil.h>

int		num_machines;
char		*server_name[N];

Display 	*display[N];
int       	screen[N];
Visual    	*visual[N];
Window  	rwin[N],draw_win[N],control_win[N],
  		display_root_win[N];
GC		draw_gc[N][NUM_PENS],control_gc[N],draw_gc_xor[N],
  		display_root_gc[N];
Cursor		arrow_cursor[N],doodle_cursor[N],erase_cursor[N],
  		text_cursor[N],cross_cursor[N],	hand_cursor[N];
XImage		*pointer_ximage[N];
XFontStruct 	*font_info[N][NUM_PENS];

int		pen[N];

int		horiz_space[NUM_PENS],
  		text_ascent[NUM_PENS],text_descent[NUM_PENS];
Coord		text_pos[N],return_pos[N];
Coord		org[N],size[N];

int		xpos=100,ypos=100;
unsigned	app_width=500,app_height=500;
int		draw_win_width;


static char	*font_name[NUM_PENS]=
{"8x13",
 "-adobe-courier-medium-r-normal--17-120-100-100-m-100-iso8859-1",
 "-adobe-courier-medium-r-normal--24-240-75-75-m-150-iso8859-1"};

init_windows(geometry,servername)
char	*geometry,**servername;
{
  unsigned  	border_width;
  unsigned long	background,foreground,border_color;
  unsigned long gc_valuemask;
  XGCValues     gc_values;
  int		i,j;
  extern char	*gen_title();
  XSizeHints	hints;
  extern byte *create_pointer_data();

  XParseGeometry(geometry,&xpos,&ypos,&app_width,&app_height);

  draw_event_mask=KeyPressMask|ButtonPressMask|ButtonReleaseMask|
    		  Button1MotionMask|Button2MotionMask|Button3MotionMask|
		  PointerMotionHintMask;
  control_event_mask=ButtonPressMask|ExposureMask;
  gc_valuemask = GCForeground|GCBackground|GCLineWidth|GCFont|GCFunction;
  draw_win_width=app_width-control_win_width;
  
  for (i=0; i<num_machines; i++) {

    screen[i] = XDefaultScreen(display[i]);
    display_root_win[i] = XRootWindow(display[i],screen[i]);
    visual[i]=DefaultVisual(display[i],screen[i]);
    background = XWhitePixel(display[i],screen[i]);
    foreground = XBlackPixel(display[i],screen[i]);
    border_color= foreground;
    border_width=4;

    arrow_cursor[i]=XCreateFontCursor(display[i],XC_top_left_arrow);
    doodle_cursor[i]=XCreateFontCursor(display[i],XC_pencil);
    erase_cursor[i]=XCreateFontCursor(display[i],XC_dotbox);
    text_cursor[i]=XCreateFontCursor(display[i],XC_xterm);
    cross_cursor[i]=XCreateFontCursor(display[i],XC_crosshair);
    hand_cursor[i]=XCreateFontCursor(display[i],XC_hand2);

    for (j=0; j<NUM_PENS; j++)
      if ((font_info[i][j]=XLoadQueryFont(display[i],font_name[j]))==0) {
	fprintf(stderr,"couldn't load font: %s on %s, using 8x13 instead.\n",
		font_name[j],server_name[i]);
	font_info[i][j]=XLoadQueryFont(display[i],"8x13");
      }

    rwin[i] = XCreateSimpleWindow(display[i],display_root_win[i],
				  xpos,ypos,app_width+4,app_height+4,
				  border_width, border_color, background);
    XStoreName(display[i],rwin[i],gen_title(i,servername));
    hints.flags = PPosition | PSize | USSize | USPosition ;
    XSetWMNormalHints(display[i],rwin[i],&hints);
    XMapWindow(display[i],rwin[i]);

    border_width=2;
    control_win[i]=XCreateSimpleWindow(display[i],rwin[i],0,0,
				       control_win_width,app_height,
				       border_width,border_color,background);
    XSelectInput(display[i], control_win[i],control_event_mask);
    XMapWindow(display[i],control_win[i]);

    draw_win[i] = XCreateSimpleWindow(display[i],rwin[i],control_win_width,0,
				      draw_win_width,app_height,
				      border_width,border_color,background);
    XDefineCursor(display[i],draw_win[i],arrow_cursor[i]);
    XSelectInput(display[i], draw_win[i], draw_event_mask);
    XMapWindow(display[i],draw_win[i]);

    gc_values.foreground = foreground;
    gc_values.background = background;
    gc_values.line_width = 2;
    gc_values.function=GXcopy;
    gc_values.font=font_info[i][SMALL]->fid;
    control_gc[i]=XCreateGC(display[i],control_win[i],gc_valuemask,&gc_values);
    for (j=0; j<NUM_PENS; j++) {
      gc_values.line_width = (j+1)*(j+1);
      gc_values.font=font_info[i][j]->fid;
      draw_gc[i][j]=XCreateGC(display[i],draw_win[i],gc_valuemask,&gc_values);
    }
    gc_values.line_width=1;
    gc_values.foreground= foreground^background;
    gc_values.function=GXxor;
    draw_gc_xor[i]=XCreateGC(display[i],draw_win[i],gc_valuemask,&gc_values);
    gc_values.foreground= 1;
    display_root_gc[i]=XCreateGC(display[i],display_root_win[i],
				 gc_valuemask,&gc_values);
    XSetSubwindowMode(display[i],display_root_gc[i],IncludeInferiors);

    pointer_ximage[i]=XCreateImage(display[i],visual[i],8,ZPixmap,0,
				   create_pointer_data(i),
				   POINTER_WIDTH,POINTER_HEIGHT,8,0);
    action[i]=DOODLE_ACTION;

    root_event_mask[i]=paste_event_mask[i]=0;
  }

  init_text();
}

static char	win_title[N*15];

char *gen_title(machine,servername)
int	machine;
char	**servername;
{
  int	i,count;

  count=0;
  strcpy(win_title,"xphone -> ");
  for (i=0; i<num_machines; i++) {
    if (i!=machine) {
      if (count!=0)
	strcat(win_title," & ");
      strcat(win_title,servername[i]);
      count++;
    }
  }
  return(win_title);
}


static char 		pointer_bits[] = {
   0x00, 0x00, 0xfe, 0x03, 0x01, 0x04, 0xfe, 0x08, 0x10, 0x10, 0xe0, 0x10,
   0x10, 0x10, 0xe0, 0x28, 0x10, 0x44, 0x60, 0x82, 0x80, 0x41, 0x80, 0x24,
   0x00, 0x11, 0x00, 0x0a, 0x00, 0x04, 0x00, 0x00};

static byte	*pointer_data[N];

byte *create_pointer_data(machine)
{
  unsigned int	i,nrc,foreground,background;
  byte		*d,*block,bitpos;

  d=pointer_data[machine]=(byte *)malloc(POINTER_WIDTH*POINTER_HEIGHT);

  foreground=XBlackPixel(display[machine],screen[machine]);
  background=XWhitePixel(display[machine],screen[machine]);
  nrc=POINTER_WIDTH*POINTER_HEIGHT;
  block=(byte *)pointer_bits;
  bitpos=1;
  for (i=0; i<nrc; i++) {
    if (*block & bitpos)
      *d++ = foreground^background;
    else
      *d++ = 0;
    bitpos<<=1;
    if (bitpos==0) {
      bitpos=1;
      block++;
    }
  }
  return(pointer_data[machine]);
}

init_text()
{
  int	i,j;

  for (j=0; j<NUM_PENS; j++) {
    horiz_space[j] = XTextWidth(font_info[0][j]," ",1);
    text_ascent[j] = font_info[0][j]->ascent;
    text_descent[j] = font_info[0][j]->descent;
  }

  for (i=0; i<num_machines; i++) {
    text_pos[i].x = return_pos[i].x = 10;
    text_pos[i].y = 10 + i*app_height/2 + text_ascent[LARGE];
  }
}

init_controls(machine)
int	machine;
{
  int	i,j,x,y;

  control_spacing=app_height/NUM_CONTROLS;

  for (j=0; j<NUM_CONTROLS; j++) {
    x=(control_win_width-str_pix_len(machine,SMALL,control[j].label))/2;
    y=(j+1)*control_spacing;
    XDrawString(display[machine],control_win[machine],control_gc[machine],
		x,y-control_spacing/2,
		control[j].label,strlen(control[j].label));
    XDrawLine(display[machine],control_win[machine],control_gc[machine],
	      0,y,control_win_width,y);
  }
}

