/*
 * xphone.c:	sets up an interactive scratch-pad among two or more
 *		different machines
 *
 * usage:	xphone host1 [host2 [host3 ...]] [-g geometry]
 *
 * written by:	Bruno Olshausen, Copyright December 1991
 */

#include <stdio.h>

#include "control.h"
#include "graphics.h"



main(argc,argv)
int argc;
char **argv;
{
  int		i;
  char		server_display_name[40],
  		host_name[80];
  char		*geometry;

  i=0;
  gethostname(host_name,80);
  server_name[i++]=host_name;

  /* get required args */
  if (argc<2)
    fatal_error("you must provide a hostname");

  server_name[i++]=argv[1];

  argc--; argv++;

  geometry="";

  /* process optional args */
  while (--argc > 0) {
    argv++;
    if (argv[0][0] == '-') {
      switch(argv[0][1]) {
      case 'g':
	geometry=argv[1];
	argv++;
	argc--;
	continue;
      default:
	fprintf(stderr,"xphone: unknown switch %s\n", argv[0]);
	exit(1);
      }
    }
    else {
      if (i<N)
	server_name[i++]=argv[0];
      else
	fatal_error("too many machines");
    }
  }
  num_machines=i;

  /* open displays */
  if ((display[0] = XOpenDisplay(NULL)) == NULL) {
    fprintf(stderr,"Can't open display %s\n",XDisplayName(NULL));
    exit(1);
  }
  for (i=1; i<num_machines; i++) {
    strcpy(server_display_name,server_name[i]);
    strcat(server_display_name,":0");
    if ((display[i] = XOpenDisplay(server_display_name)) == NULL) {
      fprintf(stderr,"Can't open display %s\n",server_display_name);
      exit(1);
    }
  }


  /* create windows and graphic contexts */

  init_windows(geometry,server_name);

  
  /* process events */
  main_event_loop();

  XCloseDisplay(display[0]);
}


perr(s)
char *s;
{
  fprintf(stderr,"xphone: %s\n",s);
}

fatal_error(s)
char *s;
{
  perr(s);
  exit(1);
}

