% hopnet.m - simulates a Hopfield network
%
% The connectivity matrix T must be defined before executing this script
%

[N N]=size(T);

sz=sqrt(N);

% % if ~exist('V','var')
% %   V=2*(rand(N,1)>=0.5)-1;
% % end

num_iterations=10;

% display initial state
if(disp)
    h=imagesc(reshape(V,sz,sz),'EraseMode','none',[-1 1]);
    axis square
    drawnow
    pause(1)
end

% run network

for t=1:num_iterations
    
    % pick a neuron at random to flip
    i=ceil(N*rand);

    % compute net input and flip state accordingly
    if T(i,:)*V>0
        V(i)=1;
    else
        V(i)=-1;
    end

    % refresh display
    if(disp)
        set(h,'CData',reshape(V,sz,sz));
        drawnow
    end

end
