% function: runHopnet.m - simulates a Hopfield network
%
% returns the final network state
%
% Author: Joshua Abbott (joshua.abbott@berkeley.edu)
function Vfinal = runHopnet(T,num_iterations,V0)


[N N]=size(T);
sz=sqrt(N);

V = V0;


% % display network state
% h=imagesc(reshape(V,sz,sz),[-1 1]);
% colormap gray
% axis square
% drawnow
% pause(1)

for t=1:num_iterations
    
    % pick a neuron i at random
    i=randi(N);
    
    % compute input U_i
    Ui = T(i,:)*V;
    
    
    % compute new state V_i
    if Ui >= 0,
        V(i) = 1;
    else
        V(i) = -1;
    end
    
    
%        % display network state
%        set(h,'CData',reshape(V,sz,sz));
%        drawnow
    
 
end

Vfinal = V;
