% testHopnet.m - script to test hopnet

% Author: Josh Abbott (joshua.abbott@berkeley.edu)

clear; close all;

num_iterations=1000;
numNeurons = 100;


%
% p1
%
% load patterns.mat
%
% numPatterns = 3;
%
% Vs = zeros(numNeurons,1,numPatterns);
% Vs(:,:,1) = face;
% Vs(:,:,2) = X;
% Vs(:,:,3) = hi;
%
% T = zeros(numNeurons);
%
% for alpha=1:numPatterns,
%     T = T + Vs(:,:,alpha)*Vs(:,:,alpha)';
% end
% T = T./numPatterns;
% %
% % fhi=figure('Units','pixels','Position', [100 100 900 300]);
% % colormap gray
% % for i=1:numPatterns,
% %     subplot(1,3,i);
% %     imagesc(reshape(Vs(:,:,i),10,10));
% % end
%
% %
% % % initialize network state V to random values
% % % V=2*(rand(N,1)>=0.5)-1;
% %
% %
% % p1(b):
% %
% % Vs = [face;X;hi]
%
% numSample = 100; % average number of runs for corrupt parameter i
% dist = zeros(numPatterns,numSample); % record first instance of instability (#bits)
%
% for basinCtr = 1:numPatterns,
%
%     Vorig = Vs(:,:,basinCtr);
%
%     for sample=1:numSample,
%         for i=1:numNeurons,
%
%             V0 = corrupt(Vorig,i);
%             Vfinal = runHopnet(T,num_iterations,V0);
%
%             HammingDist = sum(Vorig ~= Vfinal);
%
%             if (HammingDist > 0),
%                 % update distance (number of bits different from Vorig and V0)
%                 dist(basinCtr,sample) = sum(Vorig ~= V0);
%                 break;
%
%             end
%         end
%     end
%
% end
%
% % for each pattern, show the first sign of
% disp(min(dist'));


% p1(c):
% load Vpatterns.mat; % [face,X,hi,A,B,C,...,Q]
%
% VsOrig = Vs;
% numPatternsTotal = size(Vs,3);
%
% numSample = 100;
%

% fhi=figure('Units','pixels','Position', [100 100 800 1000]);
% colormap gray
% for i=1:numPatternsTotal,
%     subplot(5,4,i);
%     imagesc(reshape(Vs(:,:,i),10,10));
%     axis off;
% end
%
%
% corrMat = zeros(numPatternsTotal);
% for i=1:numPatternsTotal,
%     for j=1:numPatternsTotal,
%         corrMat(i,j) = corr(Vs(:,:,i),Vs(:,:,j));
%     end
% end
% fhi=figure('Units','pixels','Position', [100 100 800 600]);
% colormap hot;
% imagesc(corrMat,[-1 1]);
% colorbar;


% dist = zeros(numPatternsTotal,numPatternsTotal,numSample); % record first instance of instability (#bits)
% unstable = zeros(numPatternsTotal,numPatternsTotal,numSample); % record which patterns were unstable and
% patternNumbers = zeros(numPatternsTotal,numPatternsTotal);
%
% for numPatterns = 1:numPatternsTotal,
%
%
%     % randomly reorder the Vs so we use different ones
%     Y = 1:numPatterns;
%     clear Vs;
%     %Y = randsample(numPatternsTotal,numPatterns);
%     Vs = VsOrig(:,:,Y);
%
%     % record these
%     patternNumbers(numPatterns,1:numPatterns) = Y';
%
%     T = zeros(numNeurons);
%
%     % initialize weights
%     for alpha=1:numPatterns,
%         T = T + Vs(:,:,alpha)*Vs(:,:,alpha)';
%     end
%     T = T./numPatterns;
%
%
%
%     for basinCtr = 1:numPatterns,
%
%         Vorig = Vs(:,:,basinCtr);
%
%         for sample=1:numSample,
%             for i=0:numNeurons,
%
%             V0 = corrupt(Vorig,i);
%             %V0 = Vorig;
%             Vfinal = runHopnet(T,num_iterations,V0);
%
%             HammingDist = sum(Vorig ~= Vfinal);
%
%             if (HammingDist > 0),
%                 % update distance (number of bits different from Vorig and V0)
%                 dist(numPatterns,basinCtr,sample) = i-1;
%
%                 % update unstable to record that this run was bad
%                 unstable(numPatterns,basinCtr,sample) = HammingDist;
%
%
%                 break;
%
%             end
%             end
%         end
%
%     end
%
% end




%
% p2a
%

numPatternsTotal = 20;
sparsities = [ 10, 20, 30, 40, 50 ];

% make sparse patterns
Vs = ones(length(sparsities),numNeurons,1,numPatternsTotal);
for i=1:length(sparsities),
    for j=1:numPatternsTotal,
        pattern = ones(numNeurons,1);
        flips = randsample(numNeurons,sparsities(i));
        pattern(flips) = -1;
        Vs(i,:,:,j) = pattern;
    end
end



% corrMats = zeros(length(sparsities),numPatternsTotal,numPatternsTotal);
VsOrig = Vs;
numSample = 10;

dist = zeros(length(sparsities),numPatternsTotal,numPatternsTotal,numSample); % record first instance of instability (#bits)
unstable = zeros(length(sparsities),numPatternsTotal,numPatternsTotal,numSample); % record which patterns were unstable and
patternNumbers = zeros(numPatternsTotal,numPatternsTotal);



% for sparseCtr=1:length(sparsities),
%     
%     fhi=figure('Units','pixels','Position', [100 100 800 1000]);
%     colormap gray
%     for i=1:numPatternsTotal,
%         subplot(5,4,i);
%         imagesc(reshape(Vs(sparseCtr,:,:,i),10,10));
%         axis off;
%     end
%     
%     
%     
%     for i=1:numPatternsTotal,
%         for j=1:numPatternsTotal,
%             corrMats(sparseCtr,i,j) = corr(Vs(sparseCtr,:,:,i)',Vs(sparseCtr,:,:,j)');
%         end
%     end
%     
%     
% end




% fhi=figure('Units','pixels','Position', [100 100 800 1000]);
% colormap hot
% for i=1:length(sparsities),
%     subplot(3,2,i);
%     imagesc(reshape(corrMats(i,:,:),numPatternsTotal,numPatternsTotal),[-1 1]);
%     xlabel(sprintf('%d%% Sparse',sparsities(i)));
%     %axis off;
%     colorbar;
% end





for sparseCtr=1:length(sparsities),
    
    for numPatterns = 1:numPatternsTotal,
        
        
        % randomly reorder the Vs so we use different ones
        Y = 1:numPatterns;
        clear Vs;
        %Y = randsample(numPatternsTotal,numPatterns);
        Vs = VsOrig(sparseCtr,:,:,Y);
        
        % % record these
        % patternNumbers(numPatterns,1:numPatterns) = Y';
        
        T = zeros(numNeurons);
        
        % initialize weights
        for alpha=1:numPatterns,
            T = T + Vs(:,:,:,alpha)'*Vs(:,:,:,alpha);
        end
        T = T./numPatterns;
        
        
        
        for basinCtr = 1:numPatterns,
            
            Vorig = Vs(:,:,:,basinCtr)';
            
            for sample=1:numSample,
                for i=0:numNeurons,
                    
                    V0 = corrupt(Vorig,i);
                    %V0 = Vorig;
                    Vfinal = runHopnet(T,num_iterations,V0);
                    
                    HammingDist = sum(Vorig ~= Vfinal);
                    
                    if (HammingDist > 0),
                        % update distance (number of bits different from Vorig and V0)
                        dist(sparseCtr,numPatterns,basinCtr,sample) = i-1;
                        
                        % update unstable to record that this run was bad
                        unstable(sparseCtr,numPatterns,basinCtr,sample) = HammingDist;
                        
                        
                        break;
                        
                    end
                end
            end
            
        end
    end
end