% lab2s.m - single neuron learning
% you must first load in apples and oranges data

load apples;
load oranges;

% initialize data array
data=[apples oranges];
[N K]=size(data);

% initialize teacher
teacher=[ones(1,K/2) -ones(1,K/2)];

% learning rate
eta= 0.01;

% number of trials - you may want to make this smaller or larger
num_trials= 1000;

% initialize weights
w=randn(2,1);
w0=randn(1);

% initialize data plot
figure(1); clf
plot(apples(1,:),apples(2,:),'b+',oranges(1,:),oranges(2,:),'ro')
hold on
x1=0:4;
x2=-(w(1)*x1+w0)/w(2);
axis([0 4 -1 3])
h=plot(x1,x2);

E = zeros(1, num_trials);

% loop over trials
for t=1:num_trials
  
   % compute neuron output
   y = w' * data + w0;
      
   % compute delta
   delta = teacher - y;
      
   % compute error
   error = delta * delta';
   
   % compute dw
   dw  = eta * data * delta';
   dw0 = sum(eta * delta);
      
   % update weights
   w  = w  + dw;
   w0 = w0 + dw0;
   
   % save E for this trial
   E(t) = sum(error);
   
   % update display of separating hyperplane
   x2=-(w(1)*x1+w0)/w(2);
   set(h,'YData',x2)
   drawnow
   
end

hold off

figure(2)
plot(E)

