% hebb.m - script to do hebbian learning
%
% sanger's rule with two neurons
batch_size =100;
sp = 0.2; % sparse firing rate
N=64;
X =gen_lines(N,batch_size,sp);%Inefficient to do initialize this line and not to use it


[N K]=size(X); %N is the number of dimensions of our data, K is no. of samples

% % % plot data
% % plot(X(1,:),X(2,:),'.')                     
% % title('Sanger''s rule with two neurons');
% % axis xy, axis image
% % hold on
P = 64;
% initialize weights
w=randn(N,P); %the 2 here is the same as N, w is square!       

% % % plot weight vector
% % h0=plot([0 w(1)],[0 w(2)],'r','LineWidth',2);      
% % h1=plot([0 w(3)],[0 w(4)],'r','LineWidth',2); 

num_trials=10000;
eta=0.1/K; %to sort of have a negligible effect in terms of how much each
%sample will effect the learning rate

for t=1:num_trials
  %Generate new lines this trial - batch style!
  X =gen_lines(N,batch_size,sp); 
    
  % compute neuron output for all data (can be done as one line)
  Y=w'*X; %project  w' onto x to receive our scores of output
  
  % compute dw: Hebbian learning rule 
  dw=zeros(size(w));
  r=X;
  for i=1:P;
      r=r-(Y(i,:)'*w(:,i)')';  %project the y(i)th output onto the wth corr
      %weight vector and subtracting it from the previous residual to 
      dw(:,i)=Y(i,:)*r'; %give us the dw(i)
  end
  % update weight vector by dw
  w=w + eta*dw;
  w=w*diag(1./sqrt(sum(w.*w)));  
% %   set(h0,'XData',[0 w(1)],'YData',[0 w(2)]);  % replot weight vector
% %   set(h1,'XData',[0 w(3)],'YData',[0 w(4)]);  % replot weight vector
  
% %   drawnow
% %   pause(0.25)
 if mod(t,100)==0
     disp(t)
 end
  
end

% % hold off
