% lab3.m - multilayer neural network
% you must first load in apples and oranges data

% initialize data array
data=[apples apples2 oranges oranges2];
[N K]=size(data);

% initialize teacher
teacher=[ones(1,K/2) zeros(1,K/2)];
half1=1:K/2;
half2=K/2+half1;

% learning rate
eta=.1;

% number of trials - you may want to make this longer
num_trials=1000;

% initialize weights
w=randn(2,2); % first layer weights
w0=randn(2,1);
v=randn(2,1); % second layer weights
v0=randn(1);

figure(1)
clf
% initialize data space plot
subplot(121)
plot(data(1,half1),data(2,half1),'b+',data(1,half2),data(2,half2), 'ro')
hold on
x1=[0 5];
x2=-(w(1,1)*x1+w0(1))/w(2,1);
h1=plot(x1,x2,'k--','LineWidth',2);
x3=-(w(1,2)*x1+w0(2))/w(2,2);
h2=plot(x1,x3,'k-.','LineWidth',2);
axis image, axis([0 5 -2 3])

% initialize hidden units plot
subplot(122)
datay=sigmoid(w'*data+w0*ones(1,K));
hy(1)=plot(datay(1,half1),datay(2,half1),'b+');
hold on
hy(2)=plot(datay(1,half2),datay(2,half2),'ro');
y1=[-0.1 1.1];
y2=-(v(1)*y1+v0)/v(2);
h3=plot(y1,y2,'LineWidth',2);
axis image, axis([-0.1 1.1 -0.1 1.1])

% loop over trials
for t=1:num_trials
   
   % initialize dw's, dv's and E
   
   % loop over training set
   for alpha=1:K

     % compute y layer
     % compute z layer
     % compute error
     % compute delta_z
     % compute delta_y
     % accumulate dw
     % accumulate dv
     % accumulate E

   end
   
   % update weights
   
   % save E for this trial
   
   % update display of separating hyperplane
   x2=-(w(1,1)*x1+w0(1))/w(2,1);
   set(h1,'YData',x2)
   x3=-(w(1,2)*x1+w0(2))/w(2,2);
   set(h2,'YData',x3)
   
   datay=sigmoid(w'*data+w0*ones(1,K));
   set(hy(1),'XData',datay(1,half1),'YData',datay(2,half1))
   set(hy(2),'XData',datay(1,half2),'YData',datay(2,half2))
   y2=-(v(1)*y1+v0)/v(2);
   set(h3,'YData',y2)
   
   % update E plot
   if t>1
     set(hE,'XData',[t-1 t],'YData',E(t-1:t))
   else
     figure(2)
     hE=plot(1,E(1),'EraseMode','none');
     axis([1 num_trials 0 E(1)])
   end
   
   drawnow
   
end

figure(1)
subplot(121)
hold off
subplot(122)
hold off
