function plot_hyp(model, data, labels)
figure(1); scatter(data(labels==1,1), data(labels==1,2),'b+');
hold on; scatter(data(labels==0,1), data(labels==0,2),'ro');
x1=[0 5];
w=model.W;
x2=-(w(1,1)*x1+w(3,1))/w(2,1);
plot(x1,x2,'k--','LineWidth',2);
x3=-(w(1,2)*x1+w(3,2))/w(2,2);
plot(x1,x3,'k-.','LineWidth',2);
axis image, axis([0 5 -2 3])


u=[data ones(size(data,1),1)]*model.W;
y=sigmoid(u);
figure(2); scatter(y(labels==1,1), y(labels==1,2), 'b+');
hold on; scatter(y(labels==0,1), y(labels==0,2), 'ro');
x1=[0 1];
v=model.V;
x2=-(v(1)*x1+v(3))/v(2);
plot(x1, x2, 'm', 'LineWidth',2);


function p=sigmoid(u)
p=1./(1+exp(-u));
